type TPal = record
     r:array[0..15] of byte;
     g:array[0..15] of byte;
     b:array[0..15] of byte;
end;

Var CurPal: TPal;     

{ ******************************************************************** }
procedure setpalette (nr,r,g,b: byte);
{ set palette number nr, with r,g,b values }
begin
  inline ($ed/$5b/g/        { ld de,(g)          }
          $3a/nr/$57/       { ld a,(nr): ld d,a  }
          $3a/r/            { ld a,(rood)        }
          $07/$07/$07/$07/  { 4* rlca            }
          $47/              { ld b,a             }
          $3a/b/$b0/        { ld a,(b): or b     }
          $fd/$2a/$f7/$fa/  { ld iy,(#faf7)      }
          $dd/$21/$4d/$01/  { ld ix,#014d        }
          $cd/$1c/$00);     { call #1c           }
end;
{ ******************************************************************** }
procedure getpalette (nr: Byte; var r,g,b: Byte);
{ get current palette }
var
  r2,g2,b2: Byte;

begin
  inline ($3a/nr/
          $fd/$2a/$f7/$fa/  { ld iy,(#faf7)      }
          $dd/$21/$49/$01/  { ld ix,#0149        }
          $cd/$1c/$00/      { call #1c           }
          $79/$32/g2/       { ld a,c: ld (g2),a  }
          $78/$32/b2);      { ld a,b: ld (b2),a  }

  G:=G2 and 15;
  R:=(B2 SHR 4);
  B:= B2 and 15;
end;
{ ******************************************************************** }
procedure inipalette;
{ reset palette to default values }
begin
  inline ($fd/$2a/$f7/$fa/  { ld iy,(#faf7)      }
          $dd/$21/$41/$01/  { ld ix,#0141        }
          $cd/$1c/$00);     { call #1c           }
end;

{ ******************************************************************** }
procedure LoadPal(fname: OpenString; spal:byte);
{ 
  fname: PL5 palette filename
  spal: 0->only loads the palette on CurPal;
          >0 also sets the palette automatically
}
type PBuffer = array[1..39] of byte;

var arq: file of PBuffer;
    PalBuffer: PBuffer;
    fr,cor:integer;
    
begin
  assign(arq, fname);
  reset(arq);
  read(arq,palbuffer);
  {If (Palbuffer[1]=$FE) and (Palbuffer[2]=$80) and (Palbuffer[4]=$9F) then begin}
     fr:=8; cor:=0;
     while cor<16 do begin    
         CurPal.r[cor]:=Round(palbuffer[fr] shr 4);
         CurPal.g[cor]:=Round(palbuffer[fr+1]);
         CurPal.b[cor]:=Round(palbuffer[fr] and $0F);
         if spal>0 then setpalette(cor,
                             CurPal.r[cor],
                             CurPal.g[cor],
                             CurPal.b[cor]);
         
         fr:=fr+2; 
         cor:=cor+1;
     end;
  {end;}
  close(arq);
end;
{ ******************************************************************** }
procedure FadeOUT;
{ does it really needs a description? }
var fk, fr,fl: integer;
    bR, bG, bB: byte;
    OTime:integer;

begin
   fl:=0;
   While fl<8 do begin
         for fr:=0 to 15 do begin
             getpalette(15-fr,bR,bG,bB);
             if bR>0 then bR:=bR-1;
             if bG>0 then bG:=bG-1;
             if bB>0 then bB:=bB-1;
             setpalette(15-fr,bR,bG,bB);
         end;
         fl:=fl+1;
   end;
end;
{ ******************************************************************** }
procedure BlackOut;
{ set everything BLACK }
var fr: integer;
begin
   for fr:=0 to 15 do begin
       setpalette(15-fr,0,0,0);
   end;
end;
{ ******************************************************************** }
Procedure FadeIn;
{ 
 Fades In a screen from a blacked out palette to CurPal. 
 Don't forget to call first FadeOUT or BlackOut  
}
var fk, fr,fl: integer;
    bR, bG, bB: byte;
    TempPal: TPal;
begin     
   fl:=0;        
   for fr:=0 to 15 do begin
      TempPal.r[fr]:=0; TempPal.b[fr]:=0; TempPal.g[fr]:=0;
   end;
   While fl<8 do begin
         for fr:=0 to 15 do begin
             {getpalette(fr,bR,bG,bB);}
             if TempPal.r[fr]<CurPal.r[fr] then TempPal.r[fr]:=TempPal.r[fr]+1;
             if TempPal.g[fr]<Curpal.g[fr] then TempPal.g[fr]:=TempPal.g[fr]+1;
             if TempPal.b[fr]<curpal.b[fr] then TempPal.b[fr]:=TempPal.b[fr]+1;
             setpalette(fr,TempPal.r[fr],TempPal.g[fr],TempPal.b[fr]);
         end;
         fl:=fl+1;   
         delay(10);
   end;
end;




