Var  
     Vdp0 :Byte Absolute  $f3df;
     Vdp1 :Byte Absolute  $f3e0;
     Vdp2 :byte absolute  $f3e1; 
     Vdp3 :byte absolute  $f3e2; 
     Vdp4 :byte absolute  $f3e3; 
     Vdp5 :Byte Absolute  $f3e4;
     Vdp6 :Byte absolute  $f3e5;
     Vdp7 :Byte absolute  $f3e6;
     Vdp8 :Byte Absolute  $f3e7; 
     Vdp9 :Byte Absolute  $f3e8; 
     Vdp10:Byte Absolute  $f3e9; 
     Vdp11:Byte Absolute  $f3ea;
     Vdp12:Byte Absolute  $f3eb;
     Vdp13:Byte Absolute  $f3ec;
     Vdp14:Byte Absolute  $f3ed;
     Vdp15:Byte Absolute  $f3ee;
     Vdp16:Byte Absolute  $f3ef;
     Vdp17:Byte Absolute  $f3f0;
     Vdp18:Byte Absolute  $f3f1;
     Vdp19:Byte Absolute  $f3f2;
     Vdp20:Byte Absolute  $f3f3;
     Vdp21:Byte Absolute  $f3f4;
     Vdp22:Byte Absolute  $f3f5;
     Vdp23:Byte Absolute  $f3f6;
     Vdp24:Byte Absolute  $f3f7;
     Vdp25:Byte Absolute  $f3f8;

     SprTable : integer;               { address of sprite table    }         
     PtrTable : integer;               { address of pattern table   }
     ColorTable: integer;
     SprBuf   : Array[0..127] of Byte; { sprite buffer              } 
     PtrBuf   : Array[0..511] of byte; { sprite pattern buffer      }
     aptrbuf  : integer;
     

type SprData= array[0..7] of byte;

Procedure WritePattern(ptrnum: integer; var data:SprData);
var fr:integer;
begin
  for fr:=0 to 7 do
      PtrBuf[fr]:=data[fr];
end;  

Procedure _WrtVdp(VdpRegister,Value:Byte);
begin   
    Inline($F3/
    	   $3A/Value/
           $D3/$99/
           $3A/VdpRegister/
           $F6/$80/
           $00/
           $D3/$99/$FB
           );
end;

Procedure _WriteVram(VramBlockUsed:Byte; VramAddr,RamAddr,ByteCount:Integer);
{ VramBlocUsed  = 0 = first 64 Kb
                  1 = second 64 Kb
                  2 = Expansion Vram 64 Kb }
Var Expansion, AddrHi, AddrMid, AddrLo :Byte;

begin
  If VramBlockUsed = 2 Then Expansion := $40 {Set the bit 6 (MXC) }
  Else Expansion := 0 ; {No expansion vram used}
  {AddrHi := Hi(VramAddr) Div $40;}
  AddrHi:=Hi(VramAddr) shr 6;
  If VramBlockUsed = 1 Then AddrHi := AddrHi + 4 ;
    {Set addr bit 16 in reg 14 = bit 2 }
  AddrLo := Lo(VramAddr);
  AddrMid := Hi(Vramaddr) And 63 ;

  Inline(
      $F3/$3A/ Expansion /$D3/$99/$3E/$2D/$F6/$80/$D3/$99/$3A/ AddrHi /$D3/
      $99/$3E/$0E/$F6/$80/$D3/$99/$3A/ AddrLo /$00/$D3/$99/$3A/ AddrMid /$F6/
      $40/$D3/$99/$2A/ RamAddr /$ED/$4B/ ByteCount /$7E/$D3/$98/$23/$0B/$79/
      $B0/$20/$F7/ $F3/$3e/ 0  /$D3/$99/$3E/$2D/$F6/$80/$D3/$99/$FB
      );
end;

Procedure _WriteVram2(VramAddr,RamAddr,ByteCount:Integer);
begin
  Inline(
      $F3/				 { DI			        }                 
      $AF/               { LD 	A, 0            }
      $D3/$99/ 			 { OUT 	(99h),A		    }     
      $3E/$2D/           { LD 	A, 2Dh          }
      $F6/$80/           { OR 	80h	  		    }
      $D3/$99/           { OUT 	(99h),A         }
      
      $2A/VramAddr/		 { LD HL, (VramAddr)	}
      
	  $7C/				 { LD	A, H ; A=AddrHi(VramAddr) }
      $1F/
      $1F/
      $1F/
      $1F/
      $1F/
      $1F/			     { A=AddrHi shr 6 }
      
      $D3/$99/           { OUT	(99h),A		    }
      $3E/$0E/           { LD 	A,0Eh		    }
      $F6/$80/			 { OR   80h             }
      $D3/$99/           { OUT  (99h),A         }

      $7D/				 { LD A,L ; A=AddrLo(VramAddr) }
      $00/               { NOP                  }
      $D3/$99/           { OUT	(99h),A		    }

      $7C/				 { LD A, H ; A=AddrHi(VramAddr) }
      $E6/63/			 { and 63               }
      $F6/$40/           { OR   40              }
      $D3/$99/           { OUT 	(99h),A         }
      
      { start transfer }
      $2A/RamAddr/       { LD	HL,(RamAddr)    }
      $ED/$4B/ByteCount/ { LD 	BC,(ByteCount)  }
      $7E/               { LD   A,(HL)          }
      $D3/$98/           { IN 	A,(98h)		    }
      $23/				 { INC	HL				}	
      $0B/				 { DEC	BC				}
      $79/               { LD	A,C				}
      $B0/				 { OR   B				}
      $20/$F7/           { JR	NZ, F7h			}
      
      (*           
      { not necessary? }
      $3E/$00/        	 { LD   A,0				}
      $D3/$99/           { OUT	(99h),A			}
      $3E/$2D/			 { LD   A,2Dh           }
      $F6/$80/           { OR   80h             }
      $D3/$99/           { OUT  (99h),A         }
      *)
      
      $FB                { EI                   }
      );
end;

Procedure DisableSprites; {Get some speed to graphic operations. }
begin
     Vdp8 := Vdp8 Or 2;
     _WrtVdp(8,Vdp8);
end;

Procedure EnableSprites; {Loose some speed in graphic operations. }
Begin
     Vdp8 := Vdp8 And 253;
     _WrtVdp(8,Vdp8);
End;

Procedure SpriteSize8; {Default situation }
Begin
     Vdp1 := Vdp1 And 253;
     _WrtVdp(1,Vdp1);
End;

Procedure SpriteSize16;
Begin
     Vdp1 := Vdp1 Or 2;
     _WrtVdp(1,Vdp1);
End;

Procedure SpriteSizeNormal; {Default situation }
Begin
     Vdp1 := Vdp1 And 254;
     _WrtVdp(1,Vdp1);
End;

Procedure SpriteSizeMagnified;
Begin
     Vdp1 := Vdp1 Or 1;
     _WrtVdp(1,Vdp1);
End;

Procedure InitSprites;
{ must be called before using sprites }
var f: byte;
begin                 
  {
  for f:=0 to 127 do SprBuf[f]:=255;
  for f:=0 to 511 do PtrBuf[f]:=0;
  }
  fillchar(SprBuf, 128, 255);
  fillchar(PtrBuf, 512, 0);
  SprTable:=$FA00; { ((Vdp5 And 252) * $80)+(Vdp11 * $8000); }
  PtrTable:=(Vdp6 * $800); 
  ColorTable:=SprTable-512;    
  aptrbuf:=addr(PtrBuf);

end;                             

Procedure UpdateSprites;
{ writes all sprites on vram sprite table }
begin
   _WriteVram(0,SprTable,Addr(SprBuf),128); 
end;

function Collision(x1,y1,w,h,x2,y2,w2,h2:byte):boolean;
begin
  Collision:=false;             
  if (x1<x2+w2) and (x1+w>x2) and (y1<y2+h2) and (y1+h>y2) then Collision:=true;
end;

Procedure DrawPatterns;
{ Draw all sprite patterns on PtrBuf to VRAM }
begin
  _WriteVram(0,PtrTable,Addr(PtrBuf),512);
end;

Procedure ColorSprite(Number,color: byte; ccBit: boolean);
{ make sprite X color Y }
Var cBuf : Array[0..15] Of Byte; 
    fr   : integer;
begin
   for fr:=0 to 15 do 
       if ccbit then      
          cbuf[fr]:=64 or color
       else
          cbuf[fr]:=color;
          
   _WriteVram(0,SprTable-512+Number*16,Addr(cBuf),16);   
end;

Procedure PutSprite(Number, X,Y, Pattern:byte);
{ writes a sprite on Buf }
Var fr  : integer;
begin        
   Number:=Number shl 2;           
   SprBuf[Number  ] :=Y-1;
   SprBuf[Number+1] :=X;
   SprBuf[Number+2] :=Pattern;                
   SprBuf[Number+3] :=0;
end;
