{ MAPPER.INC by Kari Lammassaari ? Finland /1996 }
{ Needs msxdos2.inc ! }          
{ ReadMapperPage fixed by SLotman 2004 }
{ all debugs by SLotman 2004           }
{ Note: mapper pages are 16kb pages    }

Const {SystemPage = 1;}
      UserPage = 0;

{Every memory mapper has this table entry.}   
Type MapperTableType = Record       
                         SlotId     :Byte;
			             PagesTotal :Byte;
                         PagesFree  :Byte;
                         PagesSystem:Byte; 
                         PagesUser :Byte; 
                         Dummy1,Dummy2,Dummy3 :Byte;
                       End;

Var MapperCount     :Byte;
    MT              :MapperTableType;
    MapperTablePtr  :integer;
    PrimaryMapper   :Byte;     {Updated by function MapperSiupport} 
    SecondaryMapper :Byte;     {If there is only one mapper SecondM = PrimM }
    WantedMapper    :Byte;     {You can set this to Primary/SecondaryMapper.} 	
                               {Defaults PrimaryMapper, which is faster.}
    JumpTablePtr    :Integer;  {Addr of mapper support routine jump table}
			   
    bc,de,hl,ix,iy  :Integer; {These return values from CallMapperPage. }


Function MapperSupport(Var MappCount:Byte):Boolean; 
{
  Checks the existence of mapper support and initializes Turbo Pascal
  mapper variables.
} 
Var HokVld:Byte Absolute $fb20;  

Begin                
   MapperTablePtr:=Addr(MT);
   
   { Check for extended BIOS support (EXTBIO) }
   If Odd(HokVld) Then Begin
      MapperSupport:=True;
      Inline( 
	     $3A/$20/$FB/        { LD A,(FB20h)  } { A = HokVld }
	     $E6/$01/            { AND 01        }
	     $B7/                { OR A          }
	     $28/$49/            { JR Z,49h      } { if no extend.bios, go Loop1        }
	     $ED/$73/$AE/$FB/    { LD (FBAEh),SP } { save stack pointer in FBAEh        }
	     $31/$AD/$FB/        { LD SP,FBADh   } { ???                                }
	     $3E/$00/            { LD A,00h      }
	     $16/$04/            { LD D,04h      } { device number of extended bios     }
	     $1E/$01/            { LD E,01h      } { func. number; get mapper table     }
	     $CD/$CA/$FF/        { CALL EXTBIO   } { CALL extended bios                 }
	     $E5/                { PUSH HL       } { save start address of mapper table }
	     $22/MapperTablePtr/ { LD (MaprP),HL } { put it into MapperTablePtr         }
	     $DD/$E1/            { POP IX        }
	     $DD/$7E/$00/        { LD A,(IX+0)   }
	     $F6/$20/            { OR 20         }
	     $32/PrimaryMapper/  { LD (Prim),A   } { put it on PrimaryMapper            }
	     $32/WantedMapper/   { LD (War),A    } { put it on WantedMapper             }
	     $06/$00/            { LD B,0        } 
	     $DD/$7E/$00/        { LD A,(IX+0)   }
	     $FE/$00/            { CP, 00h       }
	     $28/$0B/            { JR Z,0Bh      } { if A=0, jump loop1                 }
	     $04/                { INC B         }
	     $32/SecondaryMapper/{ LD (Sepper),A } { put it into SecondaryMapper        }
	     $11/$08/$00/        { LD DE,8000h   }
	     $DD/$19/            { ADD IX,DE     }
	     $18/$EE/            { JR EEh        } { ????                               }
{Loop1:} $78/                { LD A,B        }
	     $32/MapperCount/    { LD (Ma),A     } { put it into MapperCount            }
	     $AF/                { XOR A         } { A=0                                }
	     $16/$04/            { LD D,04h      } { device number of extended bios     }
	     $1E/$02/            { LD E,02h      } { func. number; get mapper support routine address }
	     $CD/$CA/$FF/        { CALL EXTBIO   } { call extended bios                 }
	     $22/JumpTablePtr/   { LD (Juptr),HL } { put the address into JumpTablePtr  }
	     $ED/$7B/$AE/$FB/    { LD SP,(FBAEh) } { restores stack pointer             }
	     $18/$04/            { JR 04h        }
	     $Ad/                { XOR L         }
	     $FB/                { EI            }
	     $AE/                { XOR (HL)      }
	     $7B                 { LD A,E        }
      );
      MappCount := MapperCount;
   End Else Begin
     MapperSupport := False;
     MapperCount := 0;
   End;
End;

Function AllocateMapperPage(SlotType,PageType :Byte; Var PageId:Integer):Boolean;
Var Id :Integer;
Begin
  Inline( 
	$21/$E1/$E9/     { LD HL,E9E1h     } { ???                }
	$22/$89/$FD/     { LD (PROCNM),HL  }
	$ED/$73/$AE/$FB/ { LD (FBAE),SP    } { save stack pointer }
	$31/$AD/$FB/     { LD SP,FBADh     } { ???                }
	$3A/SlotType/    { LD A,(SLotType) }
	$47/             { LD B,A          } { B = SlotType       }
	$3A/PageType/    { LD A,(PageType) }
	$2a/JumpTablePtr/{ LD HL,(JumpTab) } { HL=JumpTablePtr    }
	$E5/             { PUSH HL         } { ???                }
	$11/$06/$00/     { LD DE,0006h     }
	$CD/$89/$FD/     { CALL PROCNM     }
	$19/             { ADD HL,DE       }
	$D1/             { POP DE          }
	$73/             { LD (HL),E       }
	$23/             { INC HL          }
	$72/             { LD (HL),D       }
	$CD/$00/$00/     { CALL 0000h      }  { ?!?!              }
	$38/$09/         { JR C,jump1      }
	$32/Id+1/        { LD (ID+1),A     }
	$78/             { LD A,B          }
	$32/Id/          { LD (ID),A       }
	$18/$07/         { JR END          }
	$AF/             { XOR A           }
{ jump1: }
	$32/Id+1/        { LD (id+1),A     }
	$32/Id/          { LD (id),A       }
{ END:   }	
	$ED/$7B/$AE/$FB { LD SP,(FBAEh)    } { restores stack pointer }
   );
   PageId := Id;
   If Id <> 0 Then 
      AllocateMapperPage := True 
   Else 
      AllocateMapperPage := False;
End;

Function FreeMapperPage(PageId:Integer):Boolean;
Var FREESEG :Integer; 
    Status  :Byte;

Begin
    FREESEG := JumpTablePtr + 3;

    Inline(
		$21/$E1/$E9/$22/$89/$FD/$ED/$73/$AE/$FB/$31/$AD/$FB/$3A/ PageId /
		$47/$3A/ PageId+1 /$2A/ FREESEG /$E5/$11/$06/$00/$CD/$89/$FD/$19/$D1/
		$73/$23/$72/$CD/$00/$00/$38/$06/$AF/$32/Status/$18/$05/$3E/$FF/
		$32/Status/$ED/$7B/$AE/$FB
	);
    If Status <> 0 Then 
       FreeMapperPage := False 
    Else 
       FreeMapperPage := True;

End; {FreeMapperPage}

Procedure CallMapperPage(SlotId,PageNumber :Byte; CallAddress:Integer; Var A:Byte; Var BC,DE,HL,IX,IY:Integer);
Var OrigSlotId	:Byte Absolute $fd0b;
    TempA		:Byte;	
    TempBC,TempDE,TempHL,TempIX,TempIY :Integer;
	
Begin
    OrigSlotId := Mem[(Hi(CallAddress) Div 64) + $f341];
    TempA :=a; TempBC := BC;TempDE := DE;TempHl := HL;
    Inline( 
		$21/$E1/$E9/$22/$89/$FD/$ED/$73/$AE/$FB/$31/$AD/$FB/
		$2a/CallAddress/$3a/SlotId/$cd/$24/00/
		$11/$0C/$00/
		$2A/ JumptablePtr /$19/$E5/$11/$1C/$00/$CD/$89/$FD/$19/$D1/$73/$23/$72/
		$FD/$2A/PageNumber-1/$DD/$2A/CallAddress /$3A/TempA /$ED/$4B/ TempBC /
		$ED/$5B/TempDE /$2A/ TempHL /$CD/$00/$00/$32/TempA/$ED/$43/TempBC/
		$ED/$53/TempDE/$22/TempHL/$DD/$22/TempIX/$FD/$22/TempIY/
		$2a/CallAddress/$3a/OrigSlotId/$cd/$24/00/
		$ED/$7B/$AE/$FB
	 );

     A  := TempA;
	 BC := TempBC;
 	 DE := TempDE;
	 HL := TempHL;
	 IX := TempIX;
	 IY := TempIY;

End;
          
(*          
Function GetPage(MemoryAddress:Integer):Byte ;
Var PageNum :Byte;  {Used to receive Inline data .}

Begin
    Inline( 
		$21/$E1/$E9/$22/$89/$FD/$ED/$73/$AE/$FB/$31/$AD/$FB/$11/$15/$00/
		$2A/JumpTablePtr/$19/$E5/$11/$09/$00/$CD/$89/$FD/$19/$D1/$73/$23/$72/
		$2A/ MemoryAddress /$CD/$00/$00/$32/ PageNum /$ED/$7B/$AE/$FB
    );
    GetPage := PageNum;
End;
                    
Procedure PutPage(MemoryAddress:Integer;Page:Byte);
Begin
    Inline(  
		$21/$E1/$E9/$22/$89/$FD/$ED/$73/$AE/$FB/$31/$AD/$FB/$11/$12/$00/
		$2A/JumpTablePtr/$90/$19/$E5/$11/$0C/$00/$CD/$89/$FD/$19/$D1/$73/$23/$72/
		$2A/MemoryAddress /$3A/ Page /$CD/$00/$00/$ED/$7B/$AE/$FB
	);
End; {PutPage}
*)

Procedure WriteMapperPage(PageId, SourceAddress,DestinationAddress, ByteCount :Integer);
Begin
     { SlotId := Lo(PageId); PageNumber := Hi(PageId);}
     { 
      PROCNM: 
  	    stores name of expanded statement (after CALL statement) or
		expansion device (after OPEN); 0 indicates the end 
		
      FD89H PROCNM: DEFS 16

        This buffer is used to hold a device or statement name for
        examination by an extension ROM.
     }
    
      Inline ( 
	   $21/$E1/$E9/           { LD HL,E9E1h                }
	   $22/$89/$FD/           { LD (FD89h), HL  (PROCNM)   }
	   $ED/$73/$AE/$FB/       { LD (FBAEh), SP             }
	   $31/$AD/$FB/           { LD SP,FBADh                }
	   $2A/DestinationAddress/{ LD HL,(DestinationAddress) }
  	   $DD/$2A/SourceAddress/ { LD IX,(SourceAddress)      }
  	   $ED/$4B/ByteCount/     { LD BC,(ByteCount)          }
	   $C5/                   { PUSH BC                    }
	   $DD/$E5/               { PUSH IX                    }
	   $08/                   { EX AF,AF'                  }
	   $DD/$7E/$00/           { LD (IX+0),A                }
	   $08/                   { EX AF,AF'                  }
	   $E5/                   { PUSH HL                    }
	   $21/$00/$80/           { LD HL,8000h                }
	   $3A/ PageId /          { LD A,(PageID)              }
	   $CD/$24/$00/           { CALL ENASLT                }
	   $11/$0E/$00/           { LD DE,000Eh                }
	   $11/$09/$00/           { LD DE,0009h                }
	   $2A/JumpTablePtr/      { LD HL,(JumpTablePtr)       }
	   $19/                   { ADD HL,DE                  }
	   $E5/                   { PUSH HL                    }
	   $11/$0E/$00/           { LD DE,000Eh                }
	   $CD/$89/$FD/           { CALL PROCNM                }
	   $19/                   { ADD HL,DE                  }
	   $D1/                   { POP DE                     }
	   $73/                   { LD (HL),E                  }
	   $23/                   { INC HL                     }
	   $72/                   { LD (HL),D                  }
	   $3A/ PageId +1 /       { LD A,(PageID+1)            }
	   $E1/                   { POP HL                     }
	   $E5/                   { PUSH HL                    }
	   $08/                   { EX AF,AF'                  }
	   $5F/                   { LD E,A                     }
	   $08/                   { EX AF,AF'                  }
	   $CD/$00/$00/           { CALL 0000h                 }
	   $3A/$43/$F3/           { LD A,F343h                 }
	   $21/$00/$80/           { LD HL,8000h                }
	   $CD/$24/$00/           { CALL ENASLT                }
	   $E1/                   { POP HL                     }
	   $DD/$E1/               { POP IX                     }
	   $C1/                   { POP BC                     }
	   $23/                   { INC HL                     }
	   $DD/$23/               { INC IX                     }
	   $0B/                   { DEC BC                     }
	   $78/                   { LD A,B                     }
	   $B1/                   { OR C                       }
	   $20/$B8/               { JR NZ,B8h                  }
	   $ED/$7B/$AE/$FB        { LD SP,(FBAEh)              } 
      );

End; {WriteMapperPage}

Procedure ReadMapperPage(PageId, SourceAddress,DestinationAddress, ByteCount:Integer);
Begin
    {SlotId := Lo(PageId); PageNumber := Hi(PageId);}
    Inline( 
        $F3/       
		$21/$E1/$E9/ 		    	{ LD HL, E9E1h               }
		$22/$89/$FD/ 				{ LD (PROCNM),HL             }
		$ED/$73/$AE/$FB/			{ LD (FBAEh),SP              }
		$31/$AD/$FB/ 				{ LD SP, FBADh               }
		$2A/SourceAddress/      	{ LD HL,(SourceAddress)      }
		$ED/$5B/DestinationAddress/ { LD DE,(DestinationAddress) }
		$ED/$4B/ByteCount/          { LD BC,(ByteCount)          }
{Loop:} $C5/                        { PUSH BC                    }
		$D5/                        { PUSH DE                    }
		$E5/                        { PUSH HL                    }
		   { 
		     urg, ugly dirty hack, but at least
		     now it works...
		   }
		   $22/$00/$d1/     { LD ($d100),HL }
		$21/$00/$80/                { LD HL,8000h                }
		$3A/PageId/                 { LD A,(PageId)              }
		$CD/$24/$00/                { CALL ENASLT                }
		{ mudei aqui: $11/$0A/$00/                { LD DE,000Ah                }
		$11/$0a/$00/
		$11/$06/$00/                { LD DE,0006h                }
		$2A/JumpTablePtr/           { LD HL,(JumpTablePtr)       }
		$19/                        { ADD HL,DE                  }
		$E5/                        { PUSH HL                    }
		$11/$0A/$00/                { LD DE,000Ah                }
		$CD/$89/$FD/                { CALL PROCNM                } { POP HL - JP (HL)? }
		$19/                        { ADD HL,DE                  } { HL = (JumpTablePrt + 06h + 0Ah }
		$D1/                        { POP DE                     } { DE=(HL na pilha)= (JumpTablePtr + 06h)  }
		$73/                        { LD (HL),E                  }
		$23/                        { INC HL                     }
		$72/                        { LD (HL),D                  }
		$3A/PageId+1/               { LD A,(PageId+1)            }
		$E1/                        { POP HL                     } { recupera source address }
		$CD/$00/$00/                { CALL 0000h                 }
		$F5/                        { PUSH AF                    }
		$3A/$43/$F3/                { LD A,(F343h)               }
		$21/$00/$80/                { LD HL,8000h                }
		$CD/$24/$00/                { CALL ENASLT                }
		$F1/                        { POP AF                     } 
		$D1/                        { POP DE                     } { recupera dest. address }
		$C1/                        { POP BC                     } { recupera bytecount?    }
		   { 
		     urg, ugly dirty hack, but at least
		     now it works...
		   }
		   $2A/$00/$d1/     { LD HL,($d100) }
		$12/                        { LD (DE),A                  } { LD (Dest), (Src) }
		$23/						{ INC HL				     } { hl=hl+1 }
		$13/                        { INC DE                     } { de=de+1 }
		$0B/                        { DEC BC                     } { bc=bc-1 }
		$78/                        { LD A,B                     }
		$B1/                        { OR C                       } { se bc!=0, JR C2h }
		{ mudei aqui: $20/$C2/ *-62      }                               
		$C2/*-68/                   { JP NZ LOOP                 }
		$ED/$7B/$AE/$FB             { LD SP,(FBAEh)              }
		/$FB
     );   
End; {ReadMapperPage}


Function LoadMcFile(FileName:StringType):Integer; 
{ 
   Lo value = mapper slotId, Hi value = PageNunber,
   returned value 0000 = operation failed 
   The Mc - code must return stackpointer in good condition ! 
}

Var	Buffer		    :Array[0..511] Of Byte;	
   	FSize	    	:Integer;
	Address,PageId  :Integer;
    Handle 		    :Byte;
    ByteCount,OffSet:Integer;	

Begin
    FindFirst(FileName,0,Fib);

    If AllocateMapperPage(WantedMapper,1,PageId) And (MsxIOResult = 0) Then Begin
        Move(Fib.FileSize,FSize,2);  {Get Filesize to Integer}
        Handle := MsxFileOpen(filename);
  	    ByteCount := 512; OffSet := 0;
        Address := Addr(Buffer);
	    Repeat
	      MsxFileRead(Handle,Address,ByteCount);
          Write('.');
          WriteMapperPage(PageId,Address,$4000+OffSet,ByteCount);
          OffSet := OffSet + ByteCount;
          FSize := FSize - ByteCount;
        Until FSize = 0;  {All Read}
          
        MsxFileClose(Handle);
        LoadMcFile := PageId;
    End Else
        LoadMcFile := 0; {Failed}

End; {LoadNcFile}

Procedure CallMcPage(Id,Address:Integer;Var a:Byte;Var bc,de,hl,ix,iy:Integer);
begin
    CallMapperPage(Lo(Id),Hi(Id),Address,a,bc,de,hl,ix,iy);
end;


