;----------------------------------
;Title: MCIMP3 Blitz3D Userlib
;Version: 1.0 @ November 21, 2008
;Author: Jos Lucio M. Gama "SLotman"
;Website: http://www.icongames.com.br
;----------------------------------
;
;COPYRIGHT NOTICE
;Copyright 2008-2012 Jos Lucio M.Gama. All Rights Reserved.
;
;This script may be used and modified free of charge by anyone
;AS LONG AS COPYRIGHT NOTICES AND ALL THE COMMENTS REMAIN INTACT.
;By using this code you agree to indemnify Jos Lucio M. Gama from any
;liability that might arise from it's use.
;
;Selling the code for this program, in part or full, without prior
;written consent is expressly forbidden.
;
;Obtain permission before redistributing this software over the Internet
;or in any other medium. In all cases copyright and header must remain
;intact. This Copyright is in full effect in any country that has
;International Trade Agreements with the United States of America or
;with the European Union.
;-----------------------------------------------------------------------

Global winmmMP3ID = 0
;________________________________________________________________________

Function mciMP3Open(file$)
Local s$

   winmmMP3ID=winmmMP3ID + 1
	s$="open " + Chr$(34) + file$ + Chr$(34) + " Type mpegvideo alias MP3" + Str$(winmmMP3ID)
	resp=api_mciSendString(s$, 0, 0, 0);
	If resp=0 Then 
	   mciMP3SetQuality(ID,"high")
	   Return winmmMP3ID
   End If
	winmmMP3ID=winmmMP3ID - 1
	Return 0
     
End Function

;________________________________________________________________________
; set audio quality, can be high/medium/low

Function mciMP3SetQuality(ID, Quality$="high")

   api_mciSendString("setaudio MP3" + Str$(ID) + " quality " + Quality$,0,0,0)

End Function

;________________________________________________________________________

Function mciMP3Play(ID, Loop=True)
Local s$

    If Loop Then
       Return api_mciSendString("play MP3" + Str$(ID) + " from 0 Repeat", 0, 0, 0);
    Else
       Return api_mciSendString("play MP3" + Str$(ID) + " from 0", 0, 0, 0);
    End If

End Function

;________________________________________________________________________

Function mciMP3Set(ID, Option$)
	api_mciSendString("set MP3" + Str$(ID) + " " + Option$,0,0,0)
End Function

;________________________________________________________________________

Function mciMP3Seek(ID, Position$)
   ; position can be "start", "end", or millisecs
	api_mciSendString("seek MP3" + Str$(ID) + " to " + Position$,0,0,0)
End Function

;________________________________________________________________________

Function mciMP3Pause(ID)
   api_mciSendString("pause MP3" + Str$(ID), 0, 0, 0);
End Function

;________________________________________________________________________

Function mciMP3Resume(ID)
   api_mciSendString("resume MP3" + Str$(ID), 0, 0, 0);
End Function

;________________________________________________________________________

Function mciMP3Stop(ID)
   api_mciSendString("stop MP3" + Str$(ID), 0, 0, 0);
End Function

;________________________________________________________________________

Function mciMP3Close(ID)
   api_mciSendString("close MP3" + Str$(ID), 0, 0, 0);
End Function

;________________________________________________________________________
; volume between 0-100%
Function mciMP3SetVolume(ID, volume)
   api_mciSendString("setaudio MP3" + Str$(ID) + " volume to " + Str$(volume * 10), 0,0,0)
End Function

;________________________________________________________________________

Function mciMP3Status$(ID,status$)
Local winmmBank=CreateBank(200)

   For i=0 To 101
       PokeByte winmmBank,i,0
   Next

	api_mciSendString2("status MP3" + Str$(ID) + " " + status$, winmmBank, 100,0)
	ret$=""
	Repeat
 	  pp=PeekByte(winmmBank,c)
     If pp<>0 Then
        ret$=ret$+Chr$(pp)
     EndIf
	  c=c+1
	Until (pp=0) Or (c>100)
	
	FreeBank winmmBank
	
   Return ret$
End Function

;________________________________________________________________________
;return current song position in milliseconds

Function mciMP3Position(ID)
	Return Int(mciMP3Status(ID, "position"))
End Function

;________________________________________________________________________

Function mciMP3Length(ID)
	Return Int(mciMP3Status(ID, "length"))
End Function

;________________________________________________________________________
; return if song is not ready, playing, paused or stopped

Function mciMP3Mode$(ID)
	Return mciMP3Status(ID, "mode")
End Function

;________________________________________________________________________
; set playing speed 
; (percentual, normal = 100, 50 = half speed, 200 = double, etc)

Function mciMP3Speed(ID, Speed)
	mciMP3Set(ID, "speed " + Str$(speed * 10))
End Function

;________________________________________________________________________
Function mciMP3Free()
Local fr
   ; stop and closes all songs
   If winmmMP3ID > 0 Then
      ; make sure all songs are released
      For fr=1 To winmmMP3ID
          mciMP3Stop(fr)
          mciMP3Close(fr)
      Next
   End If

   winmmMP3ID = 0
End Function

;________________________________________________________________________
;________________________________________________________________________
;________________________________________________________________________