;________________________________________________________________________
; MCI library by SLotman - ICON Games 2007
; http://www.icongames.com.br
;________________________________________________________________________
; Sample usage
;________________________________________________________________________

Include "mciMP3.bb"

; open song streams
song  = mciMP3Open("media\beat00.mp3")
song2 = mciMP3Open("media\lead.mp3")

; if first song loaded correctly, start playing it
If song>0 Then
   mciMP3Play(song, True)
Else
   Print "Error opening song 1!"
End If

; just warns if couldnt find song 2
If song2=0 Then Print "Error loading song 2!"

BeatSound = LoadSound("media\beat01.wav")

; main loop
While Not KeyHit(1)
   Cls
   Locate 0,0
   Print "Playing MP3...[SPACE] to Pause, [ENTER] to Resume"
   Print "Press 1 to play a secong MP3!"
   Print "Press 2 to mute song 1; 3 to un-mute"
   Print "Press 4,5 or 6 to change song speed"
   Print "Press 7 to play normal Blitz sound"
	Print "-------------------"
	Print "Song 1
	Print "-------------------"
   Print "Position:" + mciMP3Position(song)
   Print "length  :" + mciMP3Length(song)
   Print "mode    :" + mciMP3Mode(song)
	Print "-------------------"
   Print "[ESC] To quit"
   Flip
	
   ; space - pause song 1
   If KeyHit(57) Then mciMP3Pause(song)
   ; enter - resume song 1
   If KeyHit(28) Then mciMP3Resume(song)

   ; 1 - load & play second song
   If KeyHit(2) Then
      If song2>0 Then mciMP3Play(song2, False) ; false= dont loop song
   End If

   ; 2 - mute
   If KeyHit(3) Then mciMP3SetVolume(song, 0) ; vol min.
   ; 3 - un-mute
   If KeyHit(4) Then mciMP3SetVolume(song, 100) ; vol max

   ; 4, 5 & 6 change speed
   If KeyHit(5) Then mciMP3Speed(song, 50)	; half speed
   If KeyHit(6) Then mciMP3Speed(song, 100)  ; normal speed
   If KeyHit(7) Then mciMP3Speed(song, 200)	; double speed

   ; 7 normal blitz sound sample
   If KeyHit(8) Then PlaySound BeatSound
Wend

; stop and unload songs manually (not necessary if calling mciMP3Free)
If song>0 Then
   mciMP3Stop(song)
   mciMP3Close(song)
End If

If song2>0 Then
   mciMP3Stop(song)
   mciMP3Close(song)
End If

; make sure the memory is cleaned up
; (free bank used by lib, plus stops and closes every MP3)
mciMP3Free()

Print "done."

End