;----------------------------------
;Title: XINPUT Blitz3D Userlib
;Version: 1.0 @ November 21, 2008
;Author: Jos Lucio M. Gama "SLotman"
;Website: http://www.icongames.com.br
;----------------------------------
;
;COPYRIGHT NOTICE
;Copyright 2008-2012 Jos Lucio M.Gama. All Rights Reserved.
;
;This script may be used and modified free of charge by anyone
;AS LONG AS COPYRIGHT NOTICES AND ALL THE COMMENTS REMAIN INTACT.
;By using this code you agree to indemnify Jos Lucio M. Gama from any
;liability that might arise from it's use.
;
;Selling the code for this program, in part or full, without prior
;written consent is expressly forbidden.
;
;Obtain permission before redistributing this software over the Internet
;or in any other medium. In all cases copyright and header must remain
;intact. This Copyright is in full effect in any country that has
;International Trade Agreements with the United States of America or
;with the European Union.
;-----------------------------------------------------------------------

;//
;// Device types available in XINPUT_CAPABILITIES
;//
Const XINPUT_DEVTYPE_GAMEPAD          =$01

;//
;// Device subtypes available in XINPUT_CAPABILITIES
;//
Const XINPUT_DEVSUBTYPE_GAMEPAD       =$01
Const XINPUT_DEVSUBTYPE_WHEEL         =$02
Const XINPUT_DEVSUBTYPE_ARCADE_STICK  =$03
Const XINPUT_DEVSUBTYPE_FLIGHT_SICK   =$04
Const XINPUT_DEVSUBTYPE_DANCE_PAD     =$05

;//
;// Flags For XINPUT_CAPABILITIES
;//
Const XINPUT_CAPS_VOICE_SUPPORTED     =$0004

;//
;// Constants For gamepad buttons
;//
Const XINPUT_GAMEPAD_DPAD_UP          =$0001
Const XINPUT_GAMEPAD_DPAD_DOWN        =$0002
Const XINPUT_GAMEPAD_DPAD_LEFT        =$0004
Const XINPUT_GAMEPAD_DPAD_RIGHT       =$0008
Const XINPUT_GAMEPAD_START            =$0010
Const XINPUT_GAMEPAD_BACK             =$0020
Const XINPUT_GAMEPAD_LEFT_THUMB       =$0040
Const XINPUT_GAMEPAD_RIGHT_THUMB      =$0080
Const XINPUT_GAMEPAD_LEFT_SHOULDER    =$0100
Const XINPUT_GAMEPAD_RIGHT_SHOULDER   =$0200
Const XINPUT_GAMEPAD_A                =$1000
Const XINPUT_GAMEPAD_B                =$2000
Const XINPUT_GAMEPAD_X                =$4000
Const XINPUT_GAMEPAD_Y                =$8000


;//
;// Gamepad thresholds
;//
Const XINPUT_GAMEPAD_LEFT_THUMB_DEADZONE  =7849
Const XINPUT_GAMEPAD_RIGHT_THUMB_DEADZONE =8689
Const XINPUT_GAMEPAD_TRIGGER_THRESHOLD    =30

;//
;// Flags To pass To XInputGetCapabilities
;//
Const XINPUT_FLAG_GAMEPAD             =$00000001

;//
;// Devices that support batteries
;//
Const BATTERY_DEVTYPE_GAMEPAD         =$00
Const BATTERY_DEVTYPE_HEADSET         =$01

;//
;// Flags For battery status level
;//
Const BATTERY_TYPE_DISCONNECTED       =$00    ;// This device is Not connected
Const BATTERY_TYPE_WIRED              =$01    ;// Wired device, no battery
Const BATTERY_TYPE_ALKALINE           =$02    ;// Alkaline battery source
Const BATTERY_TYPE_NIMH               =$03    ;// Nickel Metal Hydride battery source
Const BATTERY_TYPE_UNKNOWN            =$FF    ;// Cannot determine the battery Type

;// These are only valid For wireless, connected devices, with known battery types
;// The amount of use time remaining depends on the Type of device.
Const BATTERY_LEVEL_EMPTY             =$00
Const BATTERY_LEVEL_LOW               =$01
Const BATTERY_LEVEL_MEDIUM            =$02
Const BATTERY_LEVEL_FULL              =$03

;// User index definitions
Const XUSER_MAX_COUNT                 =4
Const XUSER_INDEX_ANY                 =$000000FF

;//
;// Codes returned For the gamepad keystroke
;//
Const VK_PAD_A                        =$5800
Const VK_PAD_B                        =$5801
Const VK_PAD_X                        =$5802
Const VK_PAD_Y                        =$5803
Const VK_PAD_RSHOULDER                =$5804
Const VK_PAD_LSHOULDER                =$5805
Const VK_PAD_LTRIGGER                 =$5806
Const VK_PAD_RTRIGGER                 =$5807

Const VK_PAD_DPAD_UP                  =$5810
Const VK_PAD_DPAD_DOWN                =$5811
Const VK_PAD_DPAD_LEFT                =$5812
Const VK_PAD_DPAD_RIGHT               =$5813
Const VK_PAD_START                    =$5814
Const VK_PAD_BACK                     =$5815
Const VK_PAD_LTHUMB_PRESS             =$5816
Const VK_PAD_RTHUMB_PRESS             =$5817

Const VK_PAD_LTHUMB_UP                =$5820
Const VK_PAD_LTHUMB_DOWN              =$5821
Const VK_PAD_LTHUMB_RIGHT             =$5822
Const VK_PAD_LTHUMB_LEFT              =$5823
Const VK_PAD_LTHUMB_UPLEFT            =$5824
Const VK_PAD_LTHUMB_UPRIGHT           =$5825
Const VK_PAD_LTHUMB_DOWNRIGHT         =$5826
Const VK_PAD_LTHUMB_DOWNLEFT          =$5827

Const VK_PAD_RTHUMB_UP                =$5830
Const VK_PAD_RTHUMB_DOWN              =$5831
Const VK_PAD_RTHUMB_RIGHT             =$5832
Const VK_PAD_RTHUMB_LEFT              =$5833
Const VK_PAD_RTHUMB_UPLEFT            =$5834
Const VK_PAD_RTHUMB_UPRIGHT           =$5835
Const VK_PAD_RTHUMB_DOWNRIGHT         =$5836
Const VK_PAD_RTHUMB_DOWNLEFT          =$5837

;//
;// Flags used in XINPUT_KEYSTROKE
;//
Const XINPUT_KEYSTROKE_KEYDOWN        =$0001
Const XINPUT_KEYSTROKE_KEYUP          =$0002
Const XINPUT_KEYSTROKE_REPEAT         =$0004


Dim xJoyBank(3)
Global xJoyCount

Function InitX360Joy%()
Local fr

  ; test directx installed version, if not dx 9.0c or higher, no xinput!
  hbank = CreateBank(4)
  result = api_RegOpenKey($80000002,"SOFTWARE\Microsoft\DirectX",hbank)
  If result<>0 Then 
     DebugLog "could not read directx registry key!"
     Return False
  End If

  hKey = PeekInt(hbank,0)
  DebugLog "hkey:" + hkey
  FreeBank hbank

  value_bank = CreateBank(255)
  value_bank_size = CreateBank(255)
  type_bank = CreateBank(255)

  PokeInt(type_bank,0,255)
  PokeInt(value_bank,0,255)
  PokeInt(value_bank_size,0,255)
   
  result=api_RegQueryValueEx(hKey,"Version",0,type_bank,value_bank,value_bank_size)
  If result<>0 Then
     DebugLog "could not read directx version in the registry!"
     DebugLog PeekInt(value_bank_size,0)
     Return False
  End If

  dxVersion$ = ""
  size=PeekInt(value_bank_size,0)
  For char=0 To size-1
  	  If PeekByte(value_bank,char)=0 Then Exit
	  dxVersion$ = dxVersion$ + Chr$(PeekByte(value_bank,char))
  Next
  DebugLog "DX Version:" + dxVersion$

  api_RegCloseKey(hKey)
  FreeBank value_bank
  FreeBank value_bank_size
  FreeBank type_bank

  If dxVersion<>"4.09.00.0904" And dxVersion<>"4.09.0000.0904" And Int(Left$(dxVersion,1))<=4 Then
     DebugLog "DirectX version lower than dx 9.0c!"
     Return False
  Else
     dllname$=SystemProperty ("systemdir") + "xinput9_1_0.dll"
     resp=FileType(dllname$)
     ; dll not found!
     If resp<>1 Then Return False
     DebugLog "DX version ok!"
  End If

  ; its okay to use xInput :)
  For fr=0 To 3
      xJoyBank(fr)=CreateBank(32)
  Next

  Return True

End Function

Function xCountJoys()
Local fr

  xJoyCount=0
  For fr=0 To 3
    If xJoyConnected(fr)>0 Then 
       xJoyCount = xJoyCount + 1
    End If
  Next
End Function

Function FreeX360Joy()
  For fr=0 To 3
      If xJoyBank(fr)>0 Then FreeBank xJoyBank(fr)
  Next

End Function

Function xJoyConnected(port)
    ;// Zero the bank
    api_ZeroMemory(xJoyBank(port), BankSize(xJoyBank(port)))

    ;// Get the state
    If XInputGetState(port, xJoyBank(port))=0 Then Return True Else Return False

End Function

; always call this one to poll the joystick!
Function xReadJoy%(port)
Local frame

	api_ZeroMemory(xJoyBank(port),BankSize(xJoyBank(port)))
	Return XInputGetState(port, xJoyBank(port))

End Function

Function xJoyPacket(port) ; Returns PacketNumber, usage is to see if controller has been used since last time.
   	packetnumber = PeekInt(xJoyBank(port), 0)
	Return packetnumber
End Function	

Function xJoyX(port) ; Left Thumbstick X-Axis
Local bit
    
	sThumbLX = PeekShort(xJoyBank(port),8)

    ;Preserve bit pattern: high-order bit becomes sign bit	
    bit = sThumbLX And $8000
    sThumbLX = (sThumbLX And $7FFF)
    If bit>0 Then sThumbLX = sThumbLX -32767

	Return sThumbLX / 32767.0
End Function

Function xJoyY(port) ; Left Thumbstick Y-Axis
    sThumbLY = PeekShort(xJoyBank(port), 10) 

    ;Preserve bit pattern: high-order bit becomes sign bit	
    bit = sThumbLY And $8000
    sThumbLY = (sThumbLY And $7FFF)
    If bit>0 Then sThumbLY = sThumbLY -32767

    Return sThumbLY / 32767.0
End Function

Function xJoyPitch(port) ; Right Thumbstick X-Axis
	sThumbRX = PeekShort(xJoyBank(port), 12) 

    ;Preserve bit pattern: high-order bit becomes sign bit	
    bit = sThumbRX And $8000
    sThumbRX = (sThumbRX And $7FFF)
    If bit>0 Then sThumbRX = sThumbRX -32767

	Return sThumbRX / 32767.0
End Function

Function xJoyYaw(port) ; Right Thumbstick Y-Axis
	sThumbRY = PeekShort(xJoyBank(port), 14)	

    ;Preserve bit pattern: high-order bit becomes sign bit	
    bit = sThumbRY And $8000
    sThumbRY = (sThumbRY And $7FFF)
    If bit>0 Then sThumbRY = sThumbRY -32767

	Return sThumbRY / 32767.0
End Function


Function xJoyZ%(port) ; Emulates DirectX behaviour
	bLeftTrigger = PeekByte(xJoyBank(port), 6)
	bRightTrigger = PeekByte(xJoyBank(port), 7)
	Return (bLeftTrigger-bRightTrigger)	
End Function

Function xJoyZL%(port) ; Left Trigger
	bLeftTrigger = PeekByte(xJoyBank(port),6)	
	
	Return bLeftTrigger
End Function

Function xJoyZR%(port) ; Right Trigger
	bRightTrigger = PeekByte(xJoyBank(port), 7)
	
	Return bRightTrigger
End Function


Function xJoyType(index, value)
	
	XInputGetCapabilities(index, 0, xJoyBank(index))
	
	If value = 0
		xType = PeekByte (xJoyBank(index), 0)
		Return xType
	ElseIf value = 1	
	    xSubType = PeekByte (xJoyBank(index), 1)
		Return xSubType
	ElseIf value = 2
		xFlag = PeekShort (xJoyBank(index), 2)
		Return xFlag
	EndIf 

End Function


Function xReadButtons(port)
	button = PeekShort(xJoyBank(port), 4)	
	Return button
	
End Function


; strLeft, strRight: strength to both left and right vibration (0-65535)
Function xJoyRumble(port, strLeft, strRight) 
   PokeShort xJoyBank(port), 0, strLeft
   PokeShort xJoyBank(port), 2, strRight
   XInputSetState(port, xJoyBank(port))
End Function

