Var  
     Vdp1 :Byte Absolute  $f3e0;
     Vdp5 :Byte Absolute  $f3e4;
     Vdp6 :Byte absolute  $f3e5;
     Vdp8 :Byte Absolute  $ffe7; 
     Vdp11:Byte Absolute  $ffea;

     SprTable : integer;               { address of sprite table    }         
     PtrTable : integer;               { address of pattern table   }
     SprBuf   : Array[0..127] of Byte; { sprite buffer              } 
     PtrBuf   : Array[0..1023] of byte; { sprite pattern buffer      }

type SprData= array[0..7] of byte;

Procedure WritePattern(ptrnum: integer; var data:SprData);
var fr:integer;
begin
  for fr:=0 to 7 do
      PtrBuf[fr]:=data[fr];
end;  

Procedure _WrtVdp(VdpRegister,Value:Byte);
begin   
    Inline($F3/$3A/Value/
           $D3/$99/
           $3A/VdpRegister/
           $F6/$80/
           $D3/$99/$FB
           );
end;

Procedure _WriteVram(VramBlockUsed:Byte; VramAddr,RamAddr,ByteCount:Integer);
{ VramBlocUsed  = 0 = first 64 Kb
                  1 = second 64 Kb
                  2 = Expansion Vram 64 Kb }
Var Expansion, AddrHi, AddrMid, AddrLo :Byte;

begin
  If VramBlockUsed = 2 Then Expansion := $40 {Set the bit 6 (MXC) }
  Else Expansion := 0 ; {No expansion vram used}
  {AddrHi := Hi(VramAddr) Div $40;}
  AddrHi:=Hi(VramAddr) shr 6;
  If VramBlockUsed = 1 Then AddrHi := AddrHi + 4 ;
    {Set addr bit 16 in reg 14 = bit 2 }
  AddrLo := Lo(VramAddr);
  AddrMid := Hi(Vramaddr) And 63 ;

  Inline(
      $F3/$3A/ Expansion /$D3/$99/$3E/$2D/$F6/$80/$D3/$99/$3A/ AddrHi /$D3/
      $99/$3E/$0E/$F6/$80/$D3/$99/$3A/ AddrLo /$00/$D3/$99/$3A/ AddrMid /$F6/
      $40/$D3/$99/$2A/ RamAddr /$ED/$4B/ ByteCount /$7E/$D3/$98/$23/$0B/$79/
      $B0/$20/$F7/ $F3/$3e/ 0  /$D3/$99/$3E/$2D/$F6/$80/$D3/$99/$FB
      );
end;

Procedure SetSpritePattern(PatternNumber:Byte;Var PatternArray:SprData);
Var  VramAddr :Integer;
     A  :SprData;
Begin
    A := PatternArray;
    VramAddr := (Vdp6 * $800) + (PatternNumber * 8);
    _WriteVram(0,VramAddr,Addr(A),8);
End;


Procedure DisableSprites; {Get some speed to graphic operations. }
begin
     Vdp8 := Vdp8 Or 2;
     _WrtVdp(8,Vdp8);
end;

Procedure EnableSprites; {Loose some speed in graphic operations. }
Begin
     Vdp8 := Vdp8 And 253;
     _WrtVdp(8,Vdp8);
End;

Procedure SpriteSize16;
Begin
     Vdp1 := Vdp1 Or 2;
     _WrtVdp(1,Vdp1);
End;

Procedure InitSprites;
{ must be called before using sprites }
var f: byte;
begin                 

  for f:=0 to 127 do SprBuf[f]:=255;
  for f:=0 to 1023 do PtrBuf[f]:=0;
  SprTable:=((Vdp5 And 252) * $80)+(Vdp11 * $8000); 
  PtrTable:=(Vdp6 * $800);
end;                             

Procedure UpdateSprites;
{ writes all sprites on vram sprite table }
begin
   _WriteVram(0,SprTable,Addr(SprBuf),128); 
end;

function Collision(x1,y1,w,h,x2,y2,w2,h2:byte):boolean;
begin
  Collision:=false;             
  if (x1<x2+w2) and (x1+w>x2) and (y1<y2+h2) and (y1+h>y2) then Collision:=true;
end;

Procedure DrawPatterns;
{ Draw all sprite patterns on PtrBuf to VRAM }
begin
  _WriteVram(0,PtrTable,Addr(PtrBuf),1024);
end;

Procedure ColorSprite(Number,color: byte; ccBit: boolean);
{ make sprite X color Y }
Var cBuf : Array[0..15] Of Byte; 
    fr   : integer;
begin
   for fr:=0 to 15 do 
       if ccbit then      
          cbuf[fr]:=64 or color
       else
          cbuf[fr]:=color;
          
   _WriteVram(0,SprTable-512+Number*16,Addr(cBuf),16);   
end;

Procedure PutSprite(Number, X,Y:integer; Pattern:byte);
{ writes a sprite on Buf }
Var fr  : integer;
begin             
   if x<0 then x:=255;
   if x>255 then x:=255;
     
   Number:=Number shl 2;           
   SprBuf[Number  ] :=Y-1;
   SprBuf[Number+1] :=X;
   SprBuf[Number+2] :=Pattern;
end;
