{-----------------------------------------------------------------------------}
{        General Declarations                                                 }
{-----------------------------------------------------------------------------}
Type TPString = String[255];


{Command array for the Vdp access }

Var _sx  :Integer Absolute $f562 ;
    _sy  :Integer Absolute $f564 ;
    _dx  :Integer Absolute $f566 ;
    _dy  :Integer Absolute $f568 ;
    _nx  :Integer Absolute $f56a ;
    _ny  :Integer Absolute $f56c ;
    _col :Byte Absolute    $f56e ;
    _arg :Byte Absolute    $f56f ;
    _cmd :Byte Absolute    $f570 ;

Var Jiffy: integer absolute $FC9E; 
    ClickSW: integer absolute $F3DB;

{Vdp Copy commands }

Const HMMC = $F0 ; {High speed Byte Cpu  -> Vram }
      YMMM = $E0 ; {High speed Byte Vram -> Vram in y-axis }
      HMMM = $D0 ; {High speed Byte Vram -> Vram in x- and y-axis }
      HMMV = $C0 ; {High speed Byte Vdp  -> Vram = paint a box }

      LMMC = $B0 ; {Logical Dot     Cpu  -> Vram }
      LMCM = $A0 ; {Logical Dot     Vram -> Cpu  }
      LMMM = $90 ; {Logical Dot     Vram -> Vram }
      LMMV = $80 ; {Logical Dot     Vdp  -> Vram = paint a box }


{Copy directions for the ARG-register }

      Copy_Right = 0;
      Copy_Down  = 0;
      Copy_Left  = 4;
      Copy_Up    = 8;
      ExpansionVram   = 32 ;
      Vram  = 0 ;

Const TPSET=8;

Const Mult256:array[0..3] of integer=(0,256,512,768);

Procedure Screen(mode:Byte);
{ Igual ao screen do Basic }
Const EXPTBL = $fcc0;
      CALSLT = $001C;
      CHGMOD = $005F;

Begin
     Inline  (
              $f3                { di }
             /$3a/mode           { LD A,(MODE) }
             /$fd/$2a/$c0/$fc    { LD IY,(EXPTBL - 1 }
             /$DD/$21/$5f/00     { LD IX,CHGMOD }
             /$CD/$1c/00         { CALL CALSLT }
             /$fb                { EI }
             );

End;

Procedure Color(ForeGroundColor,BackGroudColor,BorderColor:Byte);
{ Igual ao color do Basic }

Var FORCLR :Byte Absolute $F3E9;
    BAKCLR :Byte Absolute $f3ea;
    BDRCLR :Byte Absolute $f3eb;

Begin
    FORCLR := ForeGroundColor;
    BAKCLR := BackGroudColor;
    BDRCLR := BorderColor;
    Inline (  $f3/
              $fd/$2a/$c0/$fc    { LD IY,(EXPTBL - 1 }
             /$DD/$21/$62/00     { LD IX,CHGCLR }
             /$CD/$1c/00/$fb     { CALL CALSLT }
           );
End;

Procedure Print(Col,Lin:integer; color:byte; Texto:TPstring);
Var Indice: integer;
    Letra: Char;
    FORCLR:Byte Absolute $F3E9;
    OldColor: integer;
    
Begin
  OldColor:=FORCLR;
  FORCLR := Color;    
  inline($f3);
  For Indice:=1 to Length(Texto) do begin
      Letra:=Texto[Indice];
      inline(
      	$3A/col/         { LD A,col }
      	$32/$B7/$FC/     { LD ($FCB7),col }
      	$3A/lin/         { LA A,lin }
      	$32/$B9/$FC/     { LD ($FCB7),col }
      	$3a/Letra/         
      	$fd/$2a/$c0/$fc/
      	$DD/$21/$8d/$00/
      	$cd/$1c/$00
      );
      Col:=Col+6;
      if Col>255 then begin
         Col:=0; Lin:=Lin+8;
      end;
  end;        
  inline($fb);
  FORCLR:=OldColor;
end;      

Procedure SetPage(DisplayPage,ActivePage:Byte);
Const SETPAGE = $013D; {SubRom routine}

Var   DPPAGE :Byte Absolute  $FAF5;
      ACPAGE :Byte Absolute  $FAF6;

Begin
    DpPage := DispLayPage;
    AcPage := ActivePage;

    Inline (
             $f3
            /$fd/$2a/$f7/$fa    { LD IY,(EXbrsa - 1 }
            /$DD/$21/$3d/$01    { LD IX,setpage }
            /$CD/$1c/00         { CALL CALSLT }
            /$fb
             );
End;

Var
   VA:byte;
   VHL,VBC,VDE:integer;

Const
   GTSTCK=$D5;     {retorna o estado do joystick selecionado}
   GTTRIG=$D8;     {retorna o estado do botao de disparo selecionado}
   WRTPSG=$93;     {grava um byte num registro do PSG}

Procedure CallRom(VIX:integer);
BEGIN
inline($F3/$CD/*+19/$FB/$32/VA/$22/VHL/$ED/$43/VBC/$ED/$53/VDE/$18/$1B/
       $DD/$2A/VIX/$3A/VA/$2A/VHL/$ED/$4B/VBC/$ED/$5B/VDE/$08/$DB/$A8/
       $F5/$E6/$F0/$C3/$8C/$F3/$FB);
END;

Function Stick(n:byte):byte;
BEGIN
  VA:=n;
  CallRom(GTSTCK);
  Stick:=VA;
END;

Function Strig(n:byte):boolean;
BEGIN
   VA:=n;
   CallRom(GTTRIG);
   Strig:=(va<>0);
END;

Procedure Sound(r,v:byte);
BEGIN
   VA:=r;
   VDE:=v;
   CallRom(WRTPSG);
END;

Procedure _MoveDotToVram(SourceAddress :Integer;Destination_x,
Destination_y:Integer;DestinationPage:Byte;Number_x,Number_y:Integer;
LogicalOperation,Direction:Byte);
Var Address :Integer;

Begin

   Address := SourceAddress+1; {Because the firstbyte is set in CMD array. }
   _cmd:= LMMC + LogicalOperation;
   _dy := Mult256[DestinationPage] + Destination_y ;
   _arg:= Direction ;
   _dx := Destination_x;
   _nx := Number_x;
   _ny := Number_y;
   _col:= Mem[Address-1];
   Inline ($f3/$DD/$2A/Address/
          $3E/$02/$D3/$99/$3E/$8F/$D3/$99/$DB/$99/$CB/$47/
          $20/$F2/$F3/$3E/$20/$D3/$99/$3E/$11/$F6/$80/$D3/$99/$06/$0F/$0E/
          $9B/$21/$62/$F5/$ED/$B3/$3E/$2C/$F6/$80/$D3/$99/$3E/$11/$F6/$80/
          $D3/$99/$3E/$02/$D3/$99/$3E/$8F/$D3/$99/$DB/$99/$CB/$47/$28/$0D/
          $CB/$7F/$28/$EE/$DD/$7E/$00/$DD/$23/$D3/$9B/$18/$E5/$3E/$00/$D3/
          $99/$3E/$8F/$D3/$99/$DB/$99/$fb);
end ; {Lmmc}

Type StringType = String[80];

Procedure LoadGraphic(FileName :StringType;
                      Width, Height: Integer;
                      x,y:Integer;
                      Page:Byte;LogOp, ScrMod :Byte);

Var ReadBuf        :^Integer;
    Temp           :Integer Absolute ReadBuf;
    DotBuf         :^Integer;
    DotTemp        :Integer Absolute DotBuf;
    Counter,yy     :Integer;
    BufSize        :Integer;
Begin
     Case ScrMod Of
       0,1,2,3,4 :BufSize := 256 ; {Dummy option}
       5,7       :BufSize := 512 ;
       6         :BufSize := 1024;
       8         :BufSize := 256 ;
     End;
     GetMem(ReadBuf,256);
     GetMem(DotBuf,BufSize);
     FcbPointer := MsxOpen(filename);
     Counter :=Width Div (BufSize Div 256) ;
     yy :=y;

     MsxRead(FcbPointer,counter,1,Temp);
     While  (MsxIOResult = 0) Do Begin
       Case ScrMod Of
         5,7 :Inline($f3/$2A/Temp/$ED/$5B/DotTemp/$ED/$4B/Counter
                     /$7E/$F5/$CB/$3F/$CB/$3F/$CB/$3F/$CB/$3F/$12/$13/$F1/$E6/
                      $0F/$12/$13/$23/$0B/$78/$B1/$20/$E9/$fb);
                      {Split one 8-byte to two 4-bit bytes}
         6  :Inline ($f3/$DD/$2A/Temp /$FD/$2A/DotTemp
                      /$ED/$5B/Counter /$DD/$7E/$00/$06/$04/$0E/$00/$17/$CB/
                       $11/$17/$CB/$11/$FD/$71/$00/$FD/$23/$10/$F1/$1B/$DD/$23/
                       $7A/$B3/$20/$E5/$fb);
                       {Split one 8-byte to four 2-bit bytes}
         8   :Inline ($f3/
                      $2a/Temp /$ed/$5b/DotTemp /$ed/$4b /Counter /
                      $ed/$b0/$f3/$fb);
                       {Moves 8-bit data directly from readbuf to Vrambuf.}
       End; {Case}
       _MoveDotToVram(DotTemp,x,yy,Page,Width,1,LogOp,0);
       yy :=yy+1;
       MsxRead(FcbPointer,counter,1,Temp);
     End;
     MsxClose(FcbPointer);
     FreeMem(ReadBuf,256);
     FreeMem(DotBuf,BufSize);
End;

Procedure cls2;
begin
  inline ($f3/$af/          { xor a         }
          $fd/$2a/$c0/$fc/  { ld iy,(#fcc0) }
          $dd/$21/$c3/$00/  { ld ix,#c3     }
          $cd/$1c/$00/$fb); { call #1c      }
end;

Procedure Common;
begin 
   Inline (
     $F3/$3E/$20/$D3/$99/$3E/$11/$F6/$80/$D3/$99/$06/$0F/$0E/$9B/$21/
     $62/$F5/$ED/$B3/$3E/$02/$D3/$99/$3E/$0F/$F6/$80/$D3/$99/$DB/$99/
     $CB/$47/$20/$F0/$AF/$D3/$99/$3E/$8F/$D3/$99/$FB
    );
end;

Procedure  Copy_y (Source_x,Source_y:Integer;SourcePage:Byte;
                   Destination_y,Number_y:Integer;DestinationPage:Byte;
                   Direction:Byte);
Begin
   _cmd:= YMMM ;
   _sy := Mult256[SourcePage] + Source_y ;
   _dy := Mult256[DestinationPage] + Destination_y ;
   _arg:= Direction ;
   _dx := Source_x; {It`s not an error ! It's really like this.}
   {_sx := sx; <- Not used ! }
   {_nx := Number_x; <- Not used ! }
   _ny := Number_y;
  Common;
End ; {Copy_y}


Procedure Copy(X1,Y1,X2,Y2,SrcPage,DestX,DestY,DestPage:integer);
begin   
   if DestX<0 then begin
      {X1:=X1+Abs(DestX);}
      X1:=X1-DestX;
      DestX:=0;         
   end;   

   _cmd:= HMMM ;
   _sy := Mult256[SrcPage] + y1 ;
   _dy := Mult256[DestPage] + Desty ;
   _arg:= 0;
   _dx := Destx;
   _sx := x1;
   _nx := x2-x1+1;
   _ny := y2-y1+1;
   Common;
end;

Procedure CopyL(X1,Y1,X2,Y2,SrcPage,DestX,DestY,DestPage:integer; LogOp:byte);
begin
   if DestX<0 then begin
      {X1:=X1+Abs(DestX);}
      X1:=X1-DestX;
      DestX:=0;         
   end;   
{
   if X1<0 then X1:=0;     
   if DestY<0 then begin
      Y1:=Y1+DestY;
      DestY:=0;         
   end;   
}   
   _cmd:= LMMM + LogOp ;
   _sy := Mult256[SrcPage] + y1 ;
   _dy := Mult256[DestPage] + Desty ;
   _arg:= 0;
   _dx := Destx;
   _sx := x1;
   _nx := x2-x1+1;
   _ny := y2-y1+1;
  Common;
end;

function Inkey:char;
var bt:integer;
    qqc:byte absolute $FCA9;
begin
     Inkey:=chr(0);
     qqc:=1;
     Inline($f3/$fd/$2a/$c0/$fc/$DD/$21/$9F/00     
            /$CD/$1c/00/$32/bt/$fb);
     Inkey:=chr(bt);
     qqc:=0;
end;

Procedure EmptyKBDBuffer;      
var c:char;
begin
  while keypressed do c:=inkey;
end;