/*****************************************************************************
** File:
**      ay8910.h
**
** Author:
**      Daniel Vik
**
** Description:
**      Emulation of the AY8910 sound chip.
**
******************************************************************************
*/
#ifndef AY8910_H
#define AY8910_H

#ifdef __cplusplus
extern "C" {
#endif

#include "msxTypes.h"
#include "audioMixer.h"

/* Type definitions */
typedef struct AY8910 AY8910;

/* Constructor and destructor */
AY8910* ay8910Create(Mixer* mixer, UInt32 cpuClock);
void ay8910Destroy(AY8910* ay8910);

/* Register read/write methods */
void ay8910WriteAddress(AY8910* ay8910, UInt8 address);
UInt8 ay8910ReadData(AY8910* ay8910);
void ay8910WriteData(AY8910* ay8910, UInt8 data, UInt32 cpuClock);

/* The following methods are to minimize updates of MSX.c */
UInt8 ay8910GetLatch(AY8910* ay8910);
UInt8 ay8910GetRegister(AY8910* ay8910, UInt8 address);
int ay8910GetSize();


#ifdef __cplusplus
}
#endif

#endif

