/** fMSX: portable MSX emulator ******************************/
/**                                                         **/
/**                          Disk.c                         **/
/**                                                         **/
/** This file contains standard disk access drivers working **/
/** with disk images from files.                            **/
/**                                                         **/
/** Copyright (C) Marat Fayzullin 1994-2003                 **/
/**     You are not allowed to distribute this software     **/
/**     commercially. Please, notify me, if you make any    **/
/**     changes to this file.                               **/
/*************************************************************/
#ifdef DISK
 
#include "MSX.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include "unzip\unzip.h"

#ifdef __BORLANDC__
#include <io.h>
#endif

//#ifdef UNIX
//#include <unistd.h>
//#endif

#ifdef WIN32
#include <io.h>
#endif

#ifndef O_BINARY
#define O_BINARY 0
#endif

static int Drives[2] = { -1,-1 };        /* Disk image files */
static int RdOnly[2];                    /* 1 = read-only    */ 

/** DiskPresent() ********************************************/
/** Return 1 if disk drive with a given ID is present.      **/
/*************************************************************/
byte DiskPresent(byte ID)
{
  return((ID<MAXDRIVES)&&(Drives[ID]>=0));
}

/** DiskRead() ***********************************************/
/** Read requested sector from the drive into a buffer.     **/
/*************************************************************/
byte DiskRead(byte ID,byte *Buf,int N)
{
	if((ID<MAXDRIVES)&&(Drives[ID]>=0)) {
        if(lseek(Drives[ID],N*512L,0)==N*512L) {
            byte success = read(Drives[ID],Buf,512)==512;
            return success;
        }
    }

  return(0);
}

/** DiskWrite() **********************************************/
/** Write contents of the buffer into a given sector of the **/
/** disk.                                                   **/
/*************************************************************/
byte DiskWrite(byte ID,byte *Buf,int N)
{
  if((ID<MAXDRIVES)&&(Drives[ID]>=0)&&!RdOnly[ID])
    if(lseek(Drives[ID],N*512L,0)==N*512L)
      return(write(Drives[ID],Buf,512)==512);
  return(0);
}

/** ChangeDisk() *********************************************/
/** Change disk image in a given drive. Closes current disk **/
/** image if Name=0 was given. Returns 1 on success or 0 on **/
/** failure.                                                **/
/*************************************************************/
byte ChangeDisk(byte ID,char *Name)
{
char* resp;
char tempname[256];
unzFile zip;
unz_file_info info;
byte* buf;
FILE* file;
char *WorkDir;
int retval;

  /* We only have MAXDRIVES drives */
  if(ID>=MAXDRIVES) return(0);

  /* Close previous disk image */
  if(Drives[ID]>=0) 
  { 
	  close(Drives[ID]);
	  Drives[ID]=-1; 
  }

  /* If no disk image given, consider drive empty */
  if(!Name) return(1);

  resp=strstr(strlwr(Name), ".zip");
  if (resp!=NULL)
  {
	// it's a zip file, extract it somewhere...
	zip = unzOpen(Name);
	if (!zip) return(1);

	// pega primeiro arquivo do zip
 	unzGoToFirstFile(zip);
   	unzGetCurrentFileInfo(zip,&info,tempname,256,NULL,0,NULL,0);
	resp=NULL;

	// try to find the .dsk file inside the zip
  	while (resp==NULL)
	{
  	   resp = strstr(strlwr(tempname), ".dsk");
	   if (unzGoToNextFile(zip)==UNZ_END_OF_LIST_OF_FILE && resp==NULL)
	   {
	  	 // no file found!
         MessageBox(NULL,"No DSK file inside the zip!","RedMSX",MB_OK);
		 return (1);
	   }
	   unzGetCurrentFileInfo(zip,&info,tempname,256,NULL,0,NULL,0);
	}
	// ok, now extract the file first to memory...
	if (unzOpenCurrentFile(zip) != UNZ_OK) 
	{
	    MessageBox(NULL,"Couldn't open the file!","RedMSX",MB_OK);
		return(1);
	}
	// find current file info (we are looking for uncompressed file size)
	unzGetCurrentFileInfo(zip,&info,NULL,0,NULL,0,NULL,0);
	// create a buffer big enough to hold uncompressed file in memory
	buf=malloc(info.uncompressed_size);
	//*size=info.uncompressed_size;
	if(!buf)	{
		unzCloseCurrentFile(zip);
		unzClose(zip);
	    MessageBox(NULL,"Not Enough Memory!","RedMSX",MB_OK);
		return(1);
	}
	// load into buffer
	unzReadCurrentFile(zip, buf, info.uncompressed_size);
	unzCloseCurrentFile(zip);
	unzClose(zip);

    /* Save current directory and cd to wherever system ROMs are */
    if(ProgDir) {
        if(WorkDir=getcwd(NULL,1024)) {
            chdir(ProgDir);
        }
    }

	// now save it to file
	switch(ID)
	{
		case 0: strcpy(Name,"diska.dsk"); break;
		case 1: strcpy(Name,"diskb.dsk"); break;
	}
	if (remove(Name)>0)
	{
       MessageBox(NULL,"Error removing old dsk file!","RedMSX",MB_OK);
   	   return(1);
	}

	file=fopen(Name,"wb");
	if (file==NULL)
	{
       MessageBox(NULL,"Could not unzip dsk image!\nCheck your writing permissions","RedMSX",MB_OK);
   	   return(1);
	}
	//retval=fwrite(buf,info.uncompressed_size,1,file);
	retval=fwrite(buf,info.uncompressed_size,1,file);
	if (retval!=1)
	{
       MessageBox(NULL,"Could not unzip dsk image!\nCheck your writing permissions","RedMSX",MB_OK);
   	   return(1);
	}
	fclose(file);
	
	// now read it normally...
  }

  /* Open new disk image */
  Drives[ID]=open(Name,O_RDWR|O_BINARY);
  RdOnly[ID]=0;

  /* If failed to open for writing, open read-only */
  if(Drives[ID]<0)
  {
  	Drives[ID]=open(Name,O_RDONLY|O_BINARY);
	RdOnly[ID]=1;
  }

  /* Get back to where it was */
  if(WorkDir) chdir(WorkDir);

  free(buf);

  /* Return operation result */
  return(Drives[ID]>=0);
}

#endif /* DISK */
