/*****************************************************************************
** File:
**      scc.h
**
** Author:
**      Daniel Vik
**
** Description:
**      Emulation of the Konami SCC sound chip.
**
******************************************************************************
*/
#ifndef SCC_H
#define SCC_H

#include "msxTypes.h"
#include "audioMixer.h"

/* Type definitions */
typedef struct SCC SCC;

/* Constructor and destructor */
SCC* sccCreate(Mixer* mixer, UInt32 cpuClock);
void sccDestroy(SCC* scc);

/* Register read/write methods */
UInt8 sccRead(SCC* scc, UInt8 address);
UInt8 sccPlusRead(SCC* scc, UInt8 address);
void sccWrite(SCC* scc, UInt8 address, UInt8 value, UInt32 cpuClock);
void sccPlusWrite(SCC* scc, UInt8 address, UInt8 value, UInt32 cpuClock);

/* The following method are to minimize updates of MSX.c */
Int32 sccGetSize();

#endif

