/*****************************************************************************
** File:        ym2413.c
**
** Author:      Daniel Vik
**
** Description: Emulation of the YM2413 sound chip. 
**              Wraps the c++ implementation taken from openMSX
**
** History:     1.0 - 11/5 2003 Initial version
**
******************************************************************************
*/
#include "YM2413.h"
#include "openMsxYM2413.h"


#define FREQUENCY        3579545
#define SAMPLERATE       44100
#define BUFFER_SIZE      1024

extern "C" Int16* ym2413Sync(void* ref, UInt32 count);

OpenMixer dummyMixer;


OpenMixer* OpenMixer::instance() 
{
    return &dummyMixer;
}

struct YM_2413 {
    YM_2413() : ym2413("ym2413", 100, 0), address(0) {
        memset(defaultBuffer, 0, sizeof(defaultBuffer));
    }

    Mixer* mixer;
    OpenYM2413 ym2413;
    UInt8  address;
    Int16  buffer[BUFFER_SIZE];
    Int16  defaultBuffer[BUFFER_SIZE];
};


extern "C" int ym2413GetSize() {
    return sizeof(YM_2413);
}


extern "C" YM_2413* ym2413Create(Mixer* mixer, UInt32 cpuClock)
{
    YM_2413* ym2413 = new YM_2413;

    ym2413->mixer = mixer;
    //mixerRegisterChannel(mixer, ym2413Sync, ym2413);
	mixerRegisterChannel(mixer, MIXER_CHANNEL_MSX_AUDIO, ym2413Sync, ym2413);

    ym2413->ym2413.setSampleRate(SAMPLERATE);
	ym2413->ym2413.setVolume(32767 / 4);
    return ym2413;
}


extern "C" void ym2413Destroy(YM_2413* ym2413) {
    //mixerUnregisterChannel(ym2413->mixer, ym2413Sync);
	mixerUnregisterChannel(ym2413->mixer, MIXER_CHANNEL_MSX_AUDIO);
    delete ym2413;
}


extern "C" void ym2413WriteAddress(YM_2413* ym2413, UInt8 address)
{
    ym2413->address = address;
}

extern "C" void ym2413WriteData(YM_2413* ym2413, UInt8 data, UInt32 cpuClock)
{
    mixerSync(ym2413->mixer, cpuClock);
    ym2413->ym2413.writeReg(ym2413->address, data, cpuClock);
}

extern "C" static Int16* ym2413Sync(void* ref, UInt32 count) 
{
    YM_2413* ym2413 = (YM_2413*)ref;
    int* genBuf = ym2413->ym2413.updateBuffer(count);
    UInt32 i;

    if (genBuf == NULL) {
        return ym2413->defaultBuffer;
    }

    for (i = 0; i < count; i++) {
        ym2413->buffer[i] = (Int16)genBuf[i];
    }

    return ym2413->buffer;
}
