/*****************************************************************************
** File:
**      arch_Win32MouseEmu.h
**
** Author:
**      Daniel Vik
**
** Description:
**      Mouse support
**
******************************************************************************
*/
#ifndef ARCH_WIN32_MOUSEEMU_H
#define ARCH_WIN32_MOUSEEMU_H

#include <windows.h>
static HWND emuHwnd;
static int mouseDX = 0;
static int mouseDY = 0;
static int mouseLockDX;
static int mouseLockDY;
static int hasMouseLock = 0;

static void CALLBACK MouseUpdateMove(HWND hwnd, UINT uMsg, UINT_PTR idEvent, DWORD dwTime)
{
    POINT pt;
    RECT r;

    if (Prt.emuState != EMU_RUNNING) {
        if (hasMouseLock) {
            hasMouseLock = 0;
            ShowCursor(TRUE);
            ReleaseCapture();
        }
        return;
    }

    GetCursorPos(&pt);
    GetClientRect(emuHwnd, &r);
    r.left += 5;
    r.top += 5;
    r.right -= 5;
    r.bottom -= 5;
    ScreenToClient(emuHwnd, &pt);
    
    if (!PtInRect(&r, pt)) {
        if (hasMouseLock) {
            hasMouseLock = 0;
            ShowCursor(TRUE);
            ReleaseCapture();
        }
        return;
    }

    if (!hasMouseLock) {
        mouseLockDX = 0;
        mouseLockDY = 0;
        mouseDX = 0;
        mouseDY = 0;
        hasMouseLock = 1;
        ShowCursor(FALSE);
        SetCapture(emuHwnd);
        pt.x = 100;
        pt.y = 100;
        if (pProperties->joy1.type == P_JOY_MOUSE || pProperties->joy2.type == P_JOY_MOUSE) {
            ClientToScreen(emuHwnd, &pt);
            SetCursorPos(pt.x, pt.y);
        }
    }
    else if (pProperties->joy1.type == P_JOY_MOUSE || pProperties->joy2.type == P_JOY_MOUSE) {
        int DX = 100 - pt.x;
        int DY = 100 - pt.y;

        mouseDX += DX;
        mouseDY += DY;
        mouseLockDX -= DX;
        mouseLockDY -= DY;

        pt.x = mouseLockDX < -600 ? r.left   - 3  : 100;
        pt.x = mouseLockDX >  600 ? r.right  + 3  : pt.x;
        pt.y = mouseLockDY < -600 ? r.top    - 3  : 100;
        pt.y = mouseLockDY >  600 ? r.bottom + 3  : pt.y;

        if (mouseLockDX < -600 || mouseLockDX > 600 || mouseLockDY < -600 || mouseLockDY > 600) {
            hasMouseLock = 0;
            ShowCursor(TRUE);
            ReleaseCapture();
        }

        ClientToScreen(emuHwnd, &pt);
        SetCursorPos(pt.x, pt.y);
    }
}

void MouseEmulationEnable(HWND hwnd) {
    emuHwnd = hwnd;
    SetTimer(emuHwnd, 1, 10, MouseUpdateMove);
}

void MouseEmulationDisable() {
    if (hasMouseLock) {
        hasMouseLock = 0;
        ShowCursor(TRUE);
        ReleaseCapture();
    }
    KillTimer(emuHwnd, 1);
}

void MouseEmulationGetState(int* dx, int* dy, int* buttons) {
    *dx = 0;
    *dy = 0;
    *buttons = 0;

    if (hasMouseLock) {
        *dx = mouseDX;
        *dy = mouseDY;

        mouseDX = 0;
        mouseDY = 0;

        if (GetKeyState(VK_LBUTTON) > 1UL) {
            *buttons |= 0x10000UL;
        }

        if (GetKeyState(VK_MBUTTON) > 1UL || GetKeyState(VK_RBUTTON) > 1UL) {
            *buttons |= 0x20000UL;
        }
    }
}


#endif
