/*****************************************************************************
** File:        arch_Win32directX.c
**
** Author:      Daniel Vik
**
** Description: Contains DirectX drawing metods.
**
** License:     Freeware. Anyone may distribute, use and modify the file 
**              without notifying the author. Even though it is not a 
**              requirement, the autor will be happy if you mention his 
**              name when using the file as is or in modified form.
**
******************************************************************************
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <windows.h>
#include <mmsystem.h>
//#include <prsht.h>

#include <ddraw.h>

#include "arch_Win32directx.h"
#include "videoRender.h"

static LPDIRECTDRAW         lpDD;		// DirectDraw object
static LPDIRECTDRAW	        lpDDinit;
static LPDIRECTDRAWSURFACE	lpDDSPrimary;	// DirectDraw primary surface
static LPDIRECTDRAWSURFACE	lpDDSBack;	// DirectDraw back surface
static LPDIRECTDRAWSURFACE	lpDDSTemp;	// DirectDraw temp surface
static LPDIRECTDRAWSURFACE	lpDDSDraw;	// DirectDraw temp surface
static LPDIRECTDRAWCLIPPER     lpClipper = NULL;      // clipper for primary
static HWND    hwndThis;
static int     MyDevice;
static char    MyDeviceName[128];
static RECT    MyDeviceRect;
static int     isFullscreen = 0;


BOOL CALLBACK OneMonitorCallback(HMONITOR hMonitor, HDC hdc, LPRECT prc, LPARAM lParam) {
    HMONITOR *phMonitorFound = (HMONITOR *)lParam;

    if (*phMonitorFound == 0) {
        *phMonitorFound = hMonitor;
    }
    else {
        *phMonitorFound = (HMONITOR) INVALID_HANDLE_VALUE;
    }

    return TRUE;
}


HMONITOR OneMonitorFromWindow(HWND hwnd) {
    HMONITOR hMonitor = NULL;
    RECT rc;

    if (hwnd) {
        GetClientRect(hwnd, &rc);
        ClientToScreen(hwnd, (LPPOINT)&rc);
        ClientToScreen(hwnd, (LPPOINT)&rc+1);
    }
    else {
        //SetRect(&rc,0,0,1,1);
        SetRectEmpty(&rc);
    }

    //EnumDisplayMonitors(NULL, &rc, OneMonitorCallback, (LPARAM)&hMonitor);
    return hMonitor;
}


int DirectDrawDeviceFromWindow(HWND hwnd, LPSTR szDevice, RECT *prc) {
    HMONITOR hMonitor;

    //if (GetSystemMetrics(SM_CMONITORS) <= 1) {
        if (prc) SetRect(prc,0,0,GetSystemMetrics(SM_CXSCREEN),GetSystemMetrics(SM_CYSCREEN));
        if (szDevice) lstrcpy(szDevice, "DISPLAY");
        return -1;
    //}

    hMonitor = OneMonitorFromWindow(hwnd);

    if (hMonitor == NULL || hMonitor == INVALID_HANDLE_VALUE) {
        if (prc) SetRectEmpty(prc);
        if (szDevice) *szDevice=0;
        return 0;
    }
    else {
        if (prc != NULL || szDevice != NULL) {
            //MONITORINFOEX mi;
            //mi.cbSize = sizeof(mi);
            //GetMonitorInfo(hMonitor, (LPMONITORINFO)&mi);
            //if (prc) *prc = mi.rcMonitor;
            //if (szDevice) lstrcpy(szDevice, mi.szDevice);
        }
        return (int)hMonitor;
    }
}

typedef struct {
    LPSTR   szDevice;
    GUID*   lpGUID;
    GUID    GUID;
    BOOL    fFound;
}   FindDeviceData;

BOOL CALLBACK FindDeviceCallback(GUID* lpGUID, LPSTR szName, LPSTR szDevice, LPVOID lParam) {
    FindDeviceData *p = (FindDeviceData*)lParam;

    if (lstrcmpi(p->szDevice, szDevice) == 0) {
	if (lpGUID) {
	    p->GUID = *lpGUID;
	    p->lpGUID = &p->GUID;
	}
	else {
	    p->lpGUID = NULL;
	}
	p->fFound = TRUE;
	return FALSE;
    }
    return TRUE;
}

IDirectDraw * DirectDrawCreateFromDevice(LPSTR szDevice) {
    IDirectDraw*    pdd = NULL;
    FindDeviceData  find;

    find.szDevice = szDevice;
    find.fFound   = FALSE;
    DirectDrawEnumerate(FindDeviceCallback, (LPVOID)&find);

    if (find.fFound) {
        DirectDrawCreate(find.lpGUID, &pdd, NULL);
    }

    return pdd;
}

IDirectDraw* DirectDrawCreateFromWindow(HWND hwnd) {
    IDirectDraw *pdd;
    char szDevice[80];

    //if (GetSystemMetrics(SM_CMONITORS) <= 1) {
        DirectDrawCreate(NULL, &pdd, NULL);
        return pdd;
    //}

    if (DirectDrawDeviceFromWindow(hwnd, szDevice, NULL)) {
        return DirectDrawCreateFromDevice(szDevice);
    }
    else {
        DirectDrawCreate(NULL, &pdd, NULL);
        return pdd;
    }
}

void DirectXExitFullscreenMode(HWND hwnd)
{
    if( lpDDSPrimary != NULL ) {
        IDirectDrawSurface_Release(lpDDSPrimary);
        lpDDSPrimary = NULL;
    }
    if( lpDDSTemp != NULL ) {
        IDirectDrawSurface_Release(lpDDSTemp);
        lpDDSTemp = NULL;
    }
    if ( lpDDSDraw != NULL ) {
        IDirectDrawSurface_Release(lpDDSDraw);
        lpDDSDraw = NULL;
    }
    if( lpDD != NULL ) {
        IDirectDraw_Release(lpDD);
        lpDD = NULL;
    }
    if( lpDDinit != NULL ) {
        IDirectDraw_SetCooperativeLevel(lpDDinit, NULL, DDSCL_NORMAL);
        IDirectDraw_RestoreDisplayMode(lpDDinit);
        IDirectDraw_Release(lpDDinit);
        lpDDinit = NULL;
    }

    isFullscreen = 0;
} /* finiObjects */


BOOL initFail(HWND hwnd, char* pStr) {
    DirectXExitFullscreenMode(hwnd);
    MessageBox( hwnd, pStr, "Error", MB_OK );
    exit(0);
    return FALSE;
}

BOOL DirectXEnterFullscreenMode(HWND hwnd, int width, int height, int depth)
{
    DDSURFACEDESC	ddsd;
    DDSCAPS		ddscaps;
    HRESULT		ddrval;

    DirectXExitFullscreenMode(hwnd);

    isFullscreen = 1;

    ddrval = DirectDrawCreate( NULL, &lpDDinit, NULL );
    if( ddrval != DD_OK ) {
        return initFail(hwnd, "Failed to create Directdraw object");
    }

    ddrval = IDirectDraw_SetCooperativeLevel(lpDDinit, NULL, DDSCL_NORMAL);
    ddrval = IDirectDraw_QueryInterface(lpDDinit, (GUID *)&IID_IDirectDraw, (LPVOID *)&lpDD);

    // Get exclusive mode
    ddrval = IDirectDraw_SetCooperativeLevel(lpDD, hwnd, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN);
    if( ddrval != DD_OK ) {
        return initFail(hwnd, "IDirectDraw_SetCooperativeLevel failed");
    }

    ddrval = IDirectDraw_SetDisplayMode(lpDD, width, height, depth);
    if( ddrval != DD_OK ) {
        return initFail(hwnd, "IDirectDraw2_SetDisplayMode failed");
    }

    // Create the primary surface with 1 back buffer
    ddsd.dwSize = sizeof( ddsd );
    ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
    ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE |
        DDSCAPS_FLIP |
        DDSCAPS_COMPLEX;
    ddsd.dwBackBufferCount = 2;
    ddrval = IDirectDraw2_CreateSurface(lpDD, &ddsd, &lpDDSPrimary, NULL );
    if( ddrval != DD_OK ) {
        return initFail(hwnd, "IDirectDraw2_CreateSurface failed");
    }

    ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
    ddrval = IDirectDrawSurface_GetAttachedSurface(lpDDSPrimary, &ddscaps, &lpDDSBack);
    if( ddrval != DD_OK ) {
        return initFail(hwnd, "IDirectDrawSurface_GetAttachedSurface failed");
    }

    ddrval = IDirectDraw_CreateClipper( lpDD, 0, &lpClipper, NULL );
    if( ddrval != DD_OK ) {
        return initFail(hwnd, "IDirectDraw_SetCooperativeLevel failed");
    }

    ddrval = IDirectDrawClipper_SetHWnd(lpClipper, 0, hwnd);
    if( ddrval != DD_OK ) {
        return initFail(hwnd, "IDirectDrawClipper_SetHWnd failed");
    }

    ddrval = IDirectDrawSurface_SetClipper(lpDDSPrimary, lpClipper );
    if( ddrval != DD_OK ) {
        return initFail(hwnd, "IDirectDrawSurface_SetClipper failed");
    }

    memset(&ddsd, 0, sizeof(DDSURFACEDESC));
    ddsd.dwSize = sizeof(DDSURFACEDESC);
    ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
    //ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_SYSTEMMEMORY;
    ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
    ddsd.dwWidth = width;
    ddsd.dwHeight = height;
    ddrval = IDirectDraw_CreateSurface(lpDD, &ddsd, &lpDDSTemp, NULL);

    return TRUE;
}



BOOL DirectXEnterWindowedMode(HWND hwnd, int width, int height)
{
    DDSURFACEDESC	ddsd;
    HRESULT		ddrval;

    hwndThis = hwnd;

    DirectXExitFullscreenMode(hwnd);

    MyDevice = DirectDrawDeviceFromWindow(hwnd, MyDeviceName, &MyDeviceRect);

    lpDD = DirectDrawCreateFromWindow(hwnd);
    if( lpDD == NULL ) {
        return initFail(hwnd, "DirectDrawCreateFromWindow failed");
    }

    ddrval = IDirectDraw_SetCooperativeLevel(lpDD, NULL, DDSCL_NORMAL);
    if( ddrval != DD_OK ) {
        return initFail(hwnd, "IDirectDraw_SetCooperativeLevel failed");
    }

    memset(&ddsd, 0, sizeof(ddsd));
    ddsd.dwSize = sizeof( ddsd );
    ddsd.dwFlags = DDSD_CAPS;
    ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;
    ddsd.dwBackBufferCount = 2;
    ddrval = IDirectDraw_CreateSurface(lpDD, &ddsd, &lpDDSPrimary, NULL );
    if( ddrval != DD_OK ) {
        return initFail(hwnd, "IDirectDraw2_CreateSurface failed");
    }

    ddrval = IDirectDraw_CreateClipper( lpDD, 0, &lpClipper, NULL );
    if( ddrval != DD_OK ) {
        return initFail(hwnd, "IDirectDraw_SetCooperativeLevel failed");
    }

    ddrval = IDirectDrawClipper_SetHWnd(lpClipper, 0, hwnd);
    if( ddrval != DD_OK ) {
        return initFail(hwnd, "IDirectDrawClipper_SetHWnd failed");
    }

    ddrval = IDirectDrawSurface_SetClipper(lpDDSPrimary, lpClipper );
    if( ddrval != DD_OK ) {
        return initFail(hwnd, "IDirectDrawSurface_SetClipper failed");
    }

    memset(&ddsd, 0, sizeof(DDSURFACEDESC));
    ddsd.dwSize = sizeof(DDSURFACEDESC);
    ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
    ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN; //| DDSCAPS_SYSTEMMEMORY;
    ddsd.dwWidth = width;
    ddsd.dwHeight = height;
    ddrval = IDirectDraw_CreateSurface(lpDD, &ddsd, &lpDDSTemp, NULL);

    return TRUE;
}

BOOL DirectXUpdateWindowedMode(HWND hwnd, int width, int height) {
    if (!isFullscreen) {
        if (MyDevice != DirectDrawDeviceFromWindow(hwnd, NULL, NULL)) {
            return DirectXEnterWindowedMode(hwnd, width, height);
        }
    }
    return TRUE;
}


char Region[2048];


//void DirectXUpdateSurface(Video* pVideo, void* srcBits, int srcWidth, int srcHeight, int dstOffset, int zoom) 
void DirectXUpdateSurface(Video* pVideo, void* srcBits, int srcWidth, int srcHeight, int srcDoubleWidth, int dstOffset, int zoom) 
{
    DDSURFACEDESC ddsd;
    LPDIRECTDRAWSURFACE surface = NULL;
    HRESULT		ddrval;

    if (lpDDSPrimary == NULL) {
        return;
    }

    if (surface == NULL && lpDDSTemp != NULL) {
        ddsd.dwSize = sizeof(ddsd);
        do {
            ddrval = IDirectDrawSurface_Lock(lpDDSTemp, NULL, &ddsd, DDLOCK_WAIT, NULL);
            if (ddrval == DDERR_SURFACELOST && IDirectDrawSurface_Restore(lpDDSTemp) != DD_OK) {
                break;
            }
        } while (ddrval == DDERR_SURFACELOST);
        if (ddrval == DD_OK) {
            surface = lpDDSTemp;
        }
    }

    if (surface == NULL) {
        ddsd.dwSize = sizeof(ddsd);
        do {
            ddrval = IDirectDrawSurface_Lock(lpDDSPrimary, NULL, &ddsd, 0, NULL);
            if (ddrval == DDERR_SURFACELOST && IDirectDrawSurface_Restore(lpDDSPrimary) != DD_OK) {
                break;
            }
        } while (ddrval == DDERR_SURFACELOST);

        if (ddrval == DD_OK) {
            surface = lpDDSPrimary;
        }
    }

    if (surface == NULL) {
        return;
    }

    //videoRender(pVideo, ddsd.ddpfPixelFormat.dwRGBBitCount, zoom, 
    //            srcBits, srcWidth, srcHeight, ddsd.lpSurface, sizeof(DWORD) * srcWidth, ddsd.lPitch);
    videoRender(pVideo, ddsd.ddpfPixelFormat.dwRGBBitCount, zoom, 
                srcBits, srcWidth, srcHeight, srcDoubleWidth, ddsd.lpSurface, sizeof(DWORD) * srcWidth, ddsd.lPitch);

    if (IDirectDrawSurface_Unlock(surface, NULL) == DDERR_SURFACELOST) {
        IDirectDrawSurface_Restore(surface);
        IDirectDrawSurface_Unlock(surface, NULL);
    }

    if (surface == lpDDSTemp) {
        RECT destRect = {0, 0, zoom * srcWidth, zoom * srcHeight + dstOffset};
        RECT rcRect = {0, 0, zoom * srcWidth, zoom * srcHeight};
        POINT pt;
        if (destRect.right  < 64) destRect.right = 64;
        if (destRect.bottom < 64)  destRect.bottom = 64;

        pt.x = pt.y = 0;
        ClientToScreen( hwndThis, &pt );
        pt.x -= MyDeviceRect.left;
        pt.y -= MyDeviceRect.top;
        OffsetRect(&destRect, pt.x, pt.y);

        if (0) { //lpDDSBack != NULL && !noFlip) {
            ddrval = IDirectDrawSurface_Blt(lpDDSBack, &rcRect, surface, &rcRect, DDBLT_WAIT, NULL);
            if (ddrval == DDERR_SURFACELOST) {
                ddrval = IDirectDrawSurface_Restore(lpDDSBack);
            }

            do {
                ddrval = IDirectDrawSurface_Flip(lpDDSPrimary, NULL, 0 );
                if (ddrval == DDERR_SURFACELOST && IDirectDrawSurface_Restore(lpDDSPrimary) != DD_OK) {
                    break;
                }
            } while (ddrval == DDERR_SURFACELOST);
        }
        else {
            rcRect.top -= dstOffset;
            //ddrval = IDirectDrawSurface_Blt(lpDDSPrimary, &destRect, surface, &rcRect, DDBLT_WAIT, NULL);
			ddrval = IDirectDrawSurface_Blt(lpDDSPrimary, &destRect, surface, &rcRect, DDBLTFAST_WAIT, NULL);
            if (ddrval == DDERR_SURFACELOST) {
                ddrval = IDirectDrawSurface_Restore(lpDDSPrimary);
            }
        }
    }
}

