/*****************************************************************************
** File:        arch_Win32snd.c
**
** Author:      Daniel Vik
**
** Description: Sound driver base
**
** License:     Freeware. Anyone may distribute, use and modify the file 
**              without notifying the author. Even though it is not a 
**              requirement, the autor will be happy if you mention his 
**              name when using the file as is or in modified form.
**
******************************************************************************
*/
#include "arch_Win32Sound.h"
#include "arch_Win32directXSound.h"
#include "arch_Win32wmmSound.h"

static DxSound* dxSound = NULL;
static WmmSound* wmmSound = NULL;

void soundCreate(HWND hwnd, SoundDriver driver, Mixer* mixer, UInt32 sampleRate, UInt32 bufferSize, Int16 channels)
{
    soundDestroy();

    switch (driver) {
    case SOUND_DRV_NONE:
        break;
    case SOUND_DRV_DIRECTX:
        dxSound = dxSoundCreate(hwnd, mixer, sampleRate, bufferSize, channels);
        break;
    case SOUND_DRV_WMM:
        wmmSound = wmmSoundCreate(hwnd, mixer, sampleRate, bufferSize, channels);
        break;
    }
}

void soundDestroy(void) 
{
    if (dxSound) {
        dxSoundDestroy(dxSound);
        dxSound = NULL;
    }
    if (wmmSound) {
        wmmSoundDestroy(wmmSound);
        wmmSound = NULL;
    }
}

void soundResume(void) 
{
    if (dxSound) {
        dxSoundResume(dxSound);
    }
    if (wmmSound) {
        wmmSoundResume(wmmSound);
    }
}


void soundSuspend(void)
{
    if (dxSound) {
        dxSoundSuspend(dxSound);
    }
    if (wmmSound) {
        wmmSoundSuspend(wmmSound);
    }
}
