/*****************************************************************************
** File:
**      arch_Win32wmmSound.h
**
** Author:
**      Daniel Vik
**
** Description:
**      WMM sound driver
**
******************************************************************************
*/
#ifndef ARCH_WIN32_WMM_SOUND
#define ARCH_WIN32_WMM_SOUND

#include <windows.h>
#include "msxTypes.h"
#include "audioMixer.h"

typedef struct WmmSound WmmSound;

WmmSound* wmmSoundCreate(HWND hwnd, Mixer* mixer, UInt32 sampleRate, UInt32 bufferSize, Int16 channels);
void wmmSoundDestroy(WmmSound* wmmSound);
void wmmSoundSuspend(WmmSound* wmmSound);
void wmmSoundResume(WmmSound* wmmSound);

#endif //ARCH_WIN32_DIRECTX_SOUND
