/*****************************************************************************
** File:        scc.c
**
** Author:      Daniel Vik
**
** Description: Emulation of key klick sound
**
** License:     Freeware. Anyone may distribute, use and modify the file 
**              without notifying the author. Even though it is not a 
**              requirement, the autor will be happy if you mention his 
**              name when using the file as is or in modified form.
**
** History:     1.0 - 11/25 2003 Initial version
**              1.1 - 12/7  2003 Adjusted volume
**
******************************************************************************
*/
#include "audioKeyClick.h"
#include <stdlib.h>
#include <string.h>

#define BUFFER_SIZE     1024


Int16 envelope[] = {
    1200, 9200, 16000, 12800, 3200, 600, 60
};

static Int16* audioKeyClickSync(void* ref, UInt32 count);

struct AudioKeyClick
{
    Mixer* mixer;
    UInt32 phase;
    Int16  buffer[BUFFER_SIZE];
};

Int32 audioKeyClickGetSize() {
    return sizeof(AudioKeyClick);
}

AudioKeyClick* audioKeyClickCreate(Mixer* mixer, UInt32 cpuClock)
{
    AudioKeyClick* keyClick = (AudioKeyClick*)calloc(1, sizeof(AudioKeyClick));

    keyClick->mixer = mixer;
    keyClick->phase = sizeof(envelope) / sizeof(Int16);

    mixerRegisterChannel(mixer, MIXER_CHANNEL_KEYBOARD, audioKeyClickSync, keyClick);

    return keyClick;
}

void audioKeyClickDestroy(AudioKeyClick* keyClick)
{
    mixerUnregisterChannel(keyClick->mixer, MIXER_CHANNEL_KEYBOARD);
    free(keyClick);
}

void audioKeyClick(AudioKeyClick* keyClick, UInt32 cpuClock)
{
    mixerSync(keyClick->mixer, cpuClock);
    keyClick->phase = 0;
}

static Int16* audioKeyClickSync(void* ref, UInt32 count)
{
    AudioKeyClick* keyClick = (AudioKeyClick*)ref;
    Int32 index = 0;

    memset(keyClick->buffer, 0, sizeof(envelope) * sizeof(Int16));

    while (count-- > 0 && keyClick->phase < sizeof(envelope) / sizeof(Int16)) {
        keyClick->buffer[index++] = envelope[keyClick->phase++];
    }

    return keyClick->buffer;
}
