/*****************************************************************************
** File:
**      audioKeyClick.h
**
** Author:
**      Daniel Vik
**
** Description:
**      Emulation of key click sound.
**
******************************************************************************
*/
#ifndef AUDIO_KEY_CLICK_H
#define AUDIO_KEY_CLICK_H

#include "msxTypes.h"
#include "audioMixer.h"

/* Type definitions */
typedef struct AudioKeyClick AudioKeyClick;

/* Constructor and destructor */
AudioKeyClick* audioKeyClickCreate(Mixer* mixer, UInt32 cpuClock);
void audioKeyClickDestroy(AudioKeyClick* keyClick);

/* Register read/write methods */
void audioKeyClick(AudioKeyClick* keyClick, UInt32 cpuClock);

/* The following method are to minimize updates of MSX.c */
Int32 audioKeyClickGetSize();

#endif

