/*****************************************************************************
** File:
**      romMapper.h
**
** Author:
**      Daniel Vik
**
** Description:
**      Determines the type of a rom image.
**
******************************************************************************
*/
#ifndef ROM_MAPPER_H
#define ROM_MAPPER_H

typedef enum {
    ROM_UNKNOWN     = -1,
    ROM_STANDARD    = 0,
    ROM_MSXDOS2     = 1,
    ROM_KONAMI5     = 2,
    ROM_KONAMI4     = 3,
    ROM_ASCII8      = 4,
    ROM_ASCII16     = 5,
    ROM_GAMEMASTER2 = 6,
    ROM_ASCII8SRAM  = 7,
    ROM_ASCII16SRAM = 8,
    ROM_RTYPE       = 9,
    ROM_KONAMIMJ2   = 10,
    ROM_PANASONICFM = 11,
    ROM_LODERUNNER  = 12,
    ROM_KONAMISYNTH = 13,
    ROM_CROSSBLAIM  = 14,
    ROM_DISKROM     = 15,
    ROM_KOREAN80    = 16,
    ROM_KOREAN126   = 17
} RomType;

extern RomType getRomType(const void* buffer, int size);

#endif /*ROM_MAPPER_H*/

